/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block;

import com.benbenlaw.strainers.block.custom.MulchBlock;
import com.benbenlaw.strainers.block.custom.StrainerTankBlock;
import com.benbenlaw.strainers.block.custom.WoodenStrainerBlock;
import com.benbenlaw.strainers.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"strainers");
    public static final DeferredBlock<Block> WOODEN_STRAINER = ModBlocks.registerBlock("wooden_strainer", () -> new WoodenStrainerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).strength(0.5f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredBlock<Block> STRAINER_TANK = ModBlocks.registerBlock("strainer_tank", () -> new StrainerTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.GLASS).noOcclusion()));
    public static final DeferredBlock<Block> MULCH = ModBlocks.registerBlock("mulch", () -> new MulchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).strength(0.5f).sound(SoundType.PACKED_MUD)));
    public static final DeferredBlock<Block> ORE_MULCH = ModBlocks.registerBlock("ore_mulch", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).strength(0.5f).sound(SoundType.PACKED_MUD)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

