/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import dev.latvian.mods.kubejs.mekanism.ChemicalComponents;
import dev.latvian.mods.kubejs.mekanism.KubeChemicalBuilder;
import dev.latvian.mods.kubejs.mekanism.MekanismChemicalWrapper;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactoryRegistry;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import dev.latvian.mods.kubejs.script.DataComponentTypeInfoRegistry;
import dev.latvian.mods.kubejs.script.TypeWrapperRegistry;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;

public class MekanismKubeJSPlugin
implements KubeJSPlugin {
    public void registerBuilderTypes(BuilderTypeRegistry registry) {
        registry.of(MekanismAPI.CHEMICAL_REGISTRY_NAME, reg -> {
            reg.addDefault(KubeChemicalBuilder.Default.class, KubeChemicalBuilder.Default::new);
            reg.add("liquid", KubeChemicalBuilder.Liquid.class, KubeChemicalBuilder.Liquid::new);
            reg.add("clean_slurry", KubeChemicalBuilder.CleanSlurry.class, KubeChemicalBuilder.CleanSlurry::new);
            reg.add("dirty_slurry", KubeChemicalBuilder.DirtySlurry.class, KubeChemicalBuilder.DirtySlurry::new);
            reg.add("infuse_type", KubeChemicalBuilder.InfuseType.class, KubeChemicalBuilder.InfuseType::new);
            reg.add("pigment", KubeChemicalBuilder.Pigment.class, KubeChemicalBuilder.Pigment::new);
        });
    }

    public void registerBindings(BindingRegistry bindings) {
        bindings.add("MekanismChemical", MekanismChemicalWrapper.class);
    }

    public void registerTypeWrappers(TypeWrapperRegistry registry) {
        registry.register(Chemical.class, MekanismChemicalWrapper::of);
        registry.register(ChemicalStack.class, MekanismChemicalWrapper::stackOf);
        registry.register(ChemicalIngredient.class, MekanismChemicalWrapper::ingredientOf);
        registry.register(ChemicalStackIngredient.class, MekanismChemicalWrapper::stackIngredientOf);
    }

    public void registerRecipeComponents(RecipeComponentFactoryRegistry registry) {
        registry.register(ChemicalComponents.CHEMICAL);
        registry.register(ChemicalComponents.CHEMICAL_STACK);
        registry.register(ChemicalComponents.CHEMICAL_INGREDIENT);
        registry.register(ChemicalComponents.CHEMICAL_STACK_INGREDIENT);
    }

    public void registerDataComponentTypeDescriptions(DataComponentTypeInfoRegistry registry) {
        try {
            TypeInfo dctt = TypeInfo.of(DataComponentType.class);
            for (Field field : MekanismDataComponents.class.getDeclaredFields()) {
                TypeInfo t;
                if (field.getType() != MekanismDeferredHolder.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !(t = TypeInfo.of((Type)field.getGenericType()).param(1)).is(dctt)) continue;
                TypeInfo t2 = t.param(0);
                DataComponentType d = (DataComponentType)((MekanismDeferredHolder)field.get(null)).get();
                registry.register(d, t2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

