/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.core.registry;

import dev.orderedchaos.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.ShortGrassBlock;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.BushConfiguration;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.FallenTreeConfiguration;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.MultipleVegetationPatchConfiguration;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.stateproviders.DirectionalStateProvider;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJFeatures;
import dev.orderedchaos.projectvibrantjourneys.data.tags.PVJTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PVJConfiguredFeatures {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registries.CONFIGURED_FEATURE, (String)"projectvibrantjourneys");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOSS_CARPETS = PVJConfiguredFeatures.createKey("moss_carpet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LILYPADS = PVJConfiguredFeatures.createKey("lilypads");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CAVE_ROOTS = PVJConfiguredFeatures.createKey("cave_roots");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BEACH_GRASS = PVJConfiguredFeatures.createKey("beach_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEA_OATS = PVJConfiguredFeatures.createKey("sea_oats");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CATTAILS = PVJConfiguredFeatures.createKey("cattails");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BARK_MUSHROOM = PVJConfiguredFeatures.createKey("bark_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_COBWEB = PVJConfiguredFeatures.createKey("natural_cobweb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHORT_GRASS = PVJConfiguredFeatures.createKey("short_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_CACTUS = PVJConfiguredFeatures.createKey("small_cactus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICICLE = PVJConfiguredFeatures.createKey("icicle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REEDS = PVJConfiguredFeatures.createKey("reeds");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PRICKLY_BUSH = PVJConfiguredFeatures.createKey("prickly_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SANDY_SPROUTS = PVJConfiguredFeatures.createKey("sandy_sprouts");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_PIECE_OF_SHORT_GRASS = PVJConfiguredFeatures.createKey("single_piece_of_short_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WATERGRASS = PVJConfiguredFeatures.createKey("watergrass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BEACHED_KELP = PVJConfiguredFeatures.createKey("beached_kelp");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRIED_BEACHED_KELP = PVJConfiguredFeatures.createKey("dried_beached_kelp");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_BLUE_FUNGUS = PVJConfiguredFeatures.createKey("glowing_blue_fungus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOATING_PINK_LOTUS = PVJConfiguredFeatures.createKey("floating_pink_lotus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OAK_BUSH = PVJConfiguredFeatures.createKey("oak_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_WILDFLOWERS = PVJConfiguredFeatures.createKey("yellow_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORANGE_WILDFLOWERS = PVJConfiguredFeatures.createKey("orange_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_WILDFLOWERS = PVJConfiguredFeatures.createKey("blue_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_WILDFLOWERS = PVJConfiguredFeatures.createKey("purple_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_WILDFLOWERS = PVJConfiguredFeatures.createKey("white_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MIXED_WILDFLOWERS = PVJConfiguredFeatures.createKey("mixed_wildflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SLIME_NODULE = PVJConfiguredFeatures.createKey("slime_nodule");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_VINES = PVJConfiguredFeatures.createKey("pink_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TWIGS = PVJConfiguredFeatures.createKey("twigs");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_TWIGS = PVJConfiguredFeatures.createKey("birch_twigs");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LEAVES = PVJConfiguredFeatures.createKey("fallen_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_FALLEN_LEAVES = PVJConfiguredFeatures.createKey("dead_fallen_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINECONES = PVJConfiguredFeatures.createKey("pinecones");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEASHELLS = PVJConfiguredFeatures.createKey("seashells");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROCKS = PVJConfiguredFeatures.createKey("rocks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_CHUNKS = PVJConfiguredFeatures.createKey("ice_chunks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BONES = PVJConfiguredFeatures.createKey("bones");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHARRED_BONES = PVJConfiguredFeatures.createKey("charred_bones");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WARPED_NETTLE = PVJConfiguredFeatures.createKey("warped_nettle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRIMSON_NETTLE = PVJConfiguredFeatures.createKey("crimson_nettle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CINDERCANE = PVJConfiguredFeatures.createKey("cindercane");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWCAP = PVJConfiguredFeatures.createKey("glowcap");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GLOWCAP = PVJConfiguredFeatures.createKey("huge_glowcap");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OAK_FALLEN_TREE = PVJConfiguredFeatures.createKey("oak_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_FALLEN_TREE = PVJConfiguredFeatures.createKey("birch_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRUCE_FALLEN_TREE = PVJConfiguredFeatures.createKey("spruce_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_FALLEN_TREE = PVJConfiguredFeatures.createKey("jungle_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ACACIA_FALLEN_TREE = PVJConfiguredFeatures.createKey("acacia_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_OAK_FALLEN_TREE = PVJConfiguredFeatures.createKey("dark_oak_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHERRY_FALLEN_TREE = PVJConfiguredFeatures.createKey("cherry_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGROVE_FALLEN_TREE = PVJConfiguredFeatures.createKey("mangrove_fallen_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEA_PICKLE = PVJConfiguredFeatures.createKey("sea_pickle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIDE_POOL = PVJConfiguredFeatures.createKey("tide_pool");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAVEL_PIT = PVJConfiguredFeatures.createKey("gravel_pit");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLD_PIT = PVJConfiguredFeatures.createKey("gold_pit");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUDDY_BONES = PVJConfiguredFeatures.createKey("muddy_bones");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LOTUS_POND = PVJConfiguredFeatures.createKey("lotus_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HOT_SPRINGS = PVJConfiguredFeatures.createKey("hot_springs");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BOGGED_REMAINS = PVJConfiguredFeatures.createKey("bogged_remains");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        RandomizedIntStateProvider SHORT_GRASS_STATE_PROVIDER = new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.SHORT_GRASS.get())), ShortGrassBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)6));
        RandomizedIntStateProvider PINECONES_STATE_PROVIDER = new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.SHORT_GRASS.get())), GroundcoverBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)4));
        RandomizedIntStateProvider PINK_PETALS_STATE_PROVIDER = new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.PINK_PETALS), PinkPetalsBlock.AMOUNT, (IntProvider)UniformInt.of((int)1, (int)4));
        List<FallenTreeConfiguration.FallenTreeVegetation> BASIC_FALLEN_TREE_VEGETATION = List.of(new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BROWN_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_CARPET), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.FALLEN_LEAVES.get())), Optional.of("enableFallenLeaves")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)SHORT_GRASS_STATE_PROVIDER, Optional.of("enableShortGrass")));
        List<FallenTreeConfiguration.FallenTreeVegetation> SPRUCE_FALLEN_TREE_VEGETATION = List.of(new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.FERN), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BROWN_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_CARPET), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.FALLEN_LEAVES.get())), Optional.of("enableFallenLeaves")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)PINECONES_STATE_PROVIDER, Optional.of("enablePinecones")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)SHORT_GRASS_STATE_PROVIDER, Optional.of("enableShortGrass")));
        List<FallenTreeConfiguration.FallenTreeVegetation> ACACIA_FALLEN_TREE_VEGETATION = List.of(new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BROWN_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.FALLEN_LEAVES.get())), Optional.of("enableFallenLeaves")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)SHORT_GRASS_STATE_PROVIDER, Optional.of("enableShortGrass")));
        List<FallenTreeConfiguration.FallenTreeVegetation> DARK_OAK_FALLEN_TREE_VEGETATION = List.of(new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.FERN), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BROWN_MUSHROOM), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_CARPET), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.FALLEN_LEAVES.get())), Optional.of("enableFallenLeaves")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)SHORT_GRASS_STATE_PROVIDER, Optional.of("enableShortGrass")));
        List<FallenTreeConfiguration.FallenTreeVegetation> CHERRY_FALLEN_TREE_VEGETATION = List.of(new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.FALLEN_LEAVES.get())), Optional.of("enableFallenLeaves")), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)PINK_PETALS_STATE_PROVIDER, Optional.empty()), new FallenTreeConfiguration.FallenTreeVegetation((BlockStateProvider)SHORT_GRASS_STATE_PROVIDER, Optional.of("enableShortGrass")));
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PVJConfiguredFeatures.register(context, MOSS_CARPETS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.mossCarpetConfig(10, 7, 2, Blocks.MOSS_CARPET));
        PVJConfiguredFeatures.register(context, LILYPADS, Feature.RANDOM_PATCH, new RandomPatchConfiguration(24, 7, 3, PlacementUtils.onlyWhenEmpty((Feature)((Feature)PVJFeatures.LILYPAD.get()), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.75f))));
        PVJConfiguredFeatures.register(context, CAVE_ROOTS, Feature.RANDOM_PATCH, new RandomPatchConfiguration(2, 2, 3, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.HANGING_ROOTS)), (BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -1, 0), (TagKey)BlockTags.DIRT))));
        PVJConfiguredFeatures.register(context, BEACH_GRASS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.BEACH_GRASS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, SEA_OATS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.SEA_OATS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, CATTAILS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.cattailConfig(128, 7, 2, ((Block)PVJBlocks.CATTAIL.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, BARK_MUSHROOM, (Feature)PVJFeatures.BARK_MUSHROOM.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, NATURAL_COBWEB, (Feature)PVJFeatures.NATURAL_COBWEB.get(), new ProbabilityFeatureConfiguration(0.1f));
        PVJConfiguredFeatures.register(context, SHORT_GRASS, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.SHORT_GRASS.get())), ShortGrassBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)6)))));
        PVJConfiguredFeatures.register(context, SMALL_CACTUS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.smallCactusConfig(8, 7, 3, ((Block)PVJBlocks.SMALL_CACTUS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, ICICLE, (Feature)PVJFeatures.ICICLE.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, REEDS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.cattailConfig(250, 12, 2, ((Block)PVJBlocks.REEDS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, PRICKLY_BUSH, Feature.RANDOM_PATCH, PVJConfiguredFeatures.randomPatchConfig(10, 7, 3, ((Block)PVJBlocks.PRICKLY_BUSH.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, SANDY_SPROUTS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.SANDY_SPROUTS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, SINGLE_PIECE_OF_SHORT_GRASS, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.SHORT_GRASS.get())), ShortGrassBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)6))));
        PVJConfiguredFeatures.register(context, WATERGRASS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.cattailConfig(250, 12, 2, ((Block)PVJBlocks.WATERGRASS.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, BEACHED_KELP, (Feature)PVJFeatures.BEACHED_KELP.get(), new BlockStateConfiguration(((Block)PVJBlocks.BEACHED_KELP.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, DRIED_BEACHED_KELP, (Feature)PVJFeatures.BEACHED_KELP.get(), new BlockStateConfiguration(((Block)PVJBlocks.DRIED_BEACHED_KELP.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, GLOWING_BLUE_FUNGUS, (Feature)PVJFeatures.GLOWING_BLUE_FUNGUS.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, FLOATING_PINK_LOTUS, Feature.RANDOM_PATCH, new RandomPatchConfiguration(24, 7, 3, PlacementUtils.onlyWhenEmpty((Feature)((Feature)PVJFeatures.FLOATING_PINK_LOTUS.get()), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.5f))));
        PVJConfiguredFeatures.register(context, OAK_BUSH, (Feature)PVJFeatures.BUSH.get(), new BushConfiguration(Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LEAVES.defaultBlockState()));
        PVJConfiguredFeatures.register(context, YELLOW_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.YELLOW_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, ORANGE_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.ORANGE_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, BLUE_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.BLUE_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, PURPLE_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.PURPLE_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, WHITE_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.WHITE_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, MIXED_WILDFLOWERS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.wildflower((PinkPetalsBlock)PVJBlocks.MIXED_WILDFLOWERS.get(), 40));
        PVJConfiguredFeatures.register(context, SLIME_NODULE, (Feature)PVJFeatures.SLIME_NODULE.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, PINK_VINES, Feature.RANDOM_PATCH, new RandomPatchConfiguration(20, 4, 1, PlacementUtils.filtered((Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)1), 1).add((Object)UniformInt.of((int)0, (int)2), 1).add((Object)UniformInt.of((int)0, (int)3), 1).add((Object)UniformInt.of((int)0, (int)4), 1).build()), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.PINK_VINES_PLANT.get()))), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.PINK_VINES.get())))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true), (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.UP.getNormal(), (Block[])new Block[]{Blocks.CHERRY_LEAVES}))));
        PVJConfiguredFeatures.register(context, TWIGS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.TWIGS.get()));
        PVJConfiguredFeatures.register(context, BIRCH_TWIGS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.BIRCH_TWIGS.get()));
        PVJConfiguredFeatures.register(context, FALLEN_LEAVES, Feature.RANDOM_PATCH, PVJConfiguredFeatures.randomPatchConfig(4, 7, 3, ((Block)PVJBlocks.FALLEN_LEAVES.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, DEAD_FALLEN_LEAVES, Feature.RANDOM_PATCH, PVJConfiguredFeatures.deadFallenLeavesConfig(3, 7, 3, ((Block)PVJBlocks.DEAD_FALLEN_LEAVES.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, PINECONES, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.PINECONES.get()));
        PVJConfiguredFeatures.register(context, SEASHELLS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.SEASHELLS.get()));
        PVJConfiguredFeatures.register(context, ROCKS, (Feature)PVJFeatures.ROCKS.get(), PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.ROCKS.get()));
        PVJConfiguredFeatures.register(context, ICE_CHUNKS, Feature.RANDOM_PATCH, PVJConfiguredFeatures.iceChunksConfig(4, 7, 3, (Block)PVJBlocks.ICE_CHUNKS.get()));
        PVJConfiguredFeatures.register(context, BONES, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(1, 7, 3, (Block)PVJBlocks.BONES.get()));
        PVJConfiguredFeatures.register(context, CHARRED_BONES, Feature.RANDOM_PATCH, PVJConfiguredFeatures.groundcoverConfig(40, 7, 3, (Block)PVJBlocks.CHARRED_BONES.get()));
        PVJConfiguredFeatures.register(context, WARPED_NETTLE, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.WARPED_NETTLE.get())), 8, 4));
        PVJConfiguredFeatures.register(context, CRIMSON_NETTLE, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PVJBlocks.CRIMSON_NETTLE.get())), 8, 4));
        PVJConfiguredFeatures.register(context, CINDERCANE, Feature.RANDOM_PATCH, PVJConfiguredFeatures.columnPlantWithFluid(256, 7, 3, (Block)PVJBlocks.CINDERCANE.get(), new Fluid[]{Fluids.LAVA, Fluids.FLOWING_LAVA}));
        PVJConfiguredFeatures.register(context, GLOWCAP, Feature.RANDOM_PATCH, PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.GLOWCAP.get()).defaultBlockState()));
        PVJConfiguredFeatures.register(context, HUGE_GLOWCAP, Feature.HUGE_RED_MUSHROOM, new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)PVJBlocks.GLOWCAP_BLOCK.get()).defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), 3));
        PVJConfiguredFeatures.register(context, OAK_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.OAK_HOLLOW_LOG.get(), Blocks.OAK_LOG, BASIC_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, BIRCH_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.BIRCH_HOLLOW_LOG.get(), Blocks.BIRCH_LOG, BASIC_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, SPRUCE_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.SPRUCE_HOLLOW_LOG.get(), Blocks.SPRUCE_LOG, SPRUCE_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, JUNGLE_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.JUNGLE_HOLLOW_LOG.get(), Blocks.JUNGLE_LOG, BASIC_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, ACACIA_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.ACACIA_HOLLOW_LOG.get(), Blocks.ACACIA_LOG, ACACIA_FALLEN_TREE_VEGETATION, false));
        PVJConfiguredFeatures.register(context, DARK_OAK_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.DARK_OAK_HOLLOW_LOG.get(), Blocks.DARK_OAK_LOG, DARK_OAK_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, CHERRY_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.CHERRY_HOLLOW_LOG.get(), Blocks.CHERRY_LOG, CHERRY_FALLEN_TREE_VEGETATION, false));
        PVJConfiguredFeatures.register(context, MANGROVE_FALLEN_TREE, (Feature)PVJFeatures.FALLEN_TREE.get(), PVJConfiguredFeatures.fallenTreeConfig((Block)PVJBlocks.MANGROVE_HOLLOW_LOG.get(), Blocks.MANGROVE_LOG, BASIC_FALLEN_TREE_VEGETATION, true));
        PVJConfiguredFeatures.register(context, SEA_PICKLE, Feature.SEA_PICKLE, new CountConfiguration(1));
        PVJConfiguredFeatures.register(context, TIDE_POOL, (Feature)PVJFeatures.POOL.get(), new MultipleVegetationPatchConfiguration((TagKey<Block>)BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE), 0.15f, List.of(PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(SEA_PICKLE), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(AquaticFeatures.SEAGRASS_TALL), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(AquaticFeatures.KELP), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(AquaticFeatures.KELP), (PlacementModifier[])new PlacementModifier[0])), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 1.0f, 5, 0.3f, (IntProvider)UniformInt.of((int)2, (int)3), 0.7f));
        PVJConfiguredFeatures.register(context, GRAVEL_PIT, (Feature)PVJFeatures.GRAVEL_PIT.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, GOLD_PIT, (Feature)PVJFeatures.GOLD_PIT.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, MUDDY_BONES, (Feature)PVJFeatures.MUDDY_BONES.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, LOTUS_POND, (Feature)PVJFeatures.LOTUS_POND.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, HOT_SPRINGS, (Feature)PVJFeatures.HOT_SPRINGS.get(), NoneFeatureConfiguration.INSTANCE);
        PVJConfiguredFeatures.register(context, BOGGED_REMAINS, (Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get(), new SimpleBlockConfiguration((BlockStateProvider)new DirectionalStateProvider((Block)PVJBlocks.BOGGED_REMAINS.get())));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectvibrantjourneys", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }

    private static RandomPatchConfiguration randomPatchConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE, Blocks.SNOW})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA, Blocks.WATER})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA, Fluids.WATER}))})));
    }

    private static RandomPatchConfiguration smallCactusConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.replaceable(), (BlockPredicate)BlockPredicate.matchesTag((Vec3i)Direction.DOWN.getNormal(), (TagKey)BlockTags.SAND))));
    }

    private static RandomPatchConfiguration deadFallenLeavesConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE, Blocks.SNOW, Blocks.RED_SAND})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesTag((Vec3i)Direction.DOWN.getNormal(), (TagKey)BlockTags.TERRACOTTA)), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA, Blocks.WATER})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA, Fluids.WATER}))})));
    }

    private static RandomPatchConfiguration cattailConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE, Blocks.SNOW})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}))})));
    }

    private static RandomPatchConfiguration groundcoverConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)new DirectionalStateProvider(block), GroundcoverBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)4))), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesTag((Vec3i)Direction.DOWN.getNormal(), PVJTags.GROUNDCOVER_CANNOT_GENERATE_ON)), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}))})));
    }

    private static RandomPatchConfiguration iceChunksConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)new DirectionalStateProvider(block), GroundcoverBlock.MODEL, (IntProvider)UniformInt.of((int)0, (int)4))), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SNOW})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}))})));
    }

    private static RandomPatchConfiguration mossCarpetConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockPredicate.replaceable((Vec3i)Direction.DOWN.getNormal())), BlockPredicate.hasSturdyFace((Vec3i)Direction.DOWN.getNormal(), (Direction)Direction.UP), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE, Blocks.SNOW, Blocks.WATER})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SNOW, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.LAVA})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Vec3i)Direction.DOWN.getNormal(), (Fluid[])new Fluid[]{Fluids.WATER})), BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}))})));
    }

    private static FallenTreeConfiguration fallenTreeConfig(Block hollowLog, Block baseLog, List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders, boolean canBeMossy) {
        return new FallenTreeConfiguration(hollowLog.defaultBlockState(), baseLog.defaultBlockState(), vegetationProviders, canBeMossy);
    }

    private static RandomPatchConfiguration simpleRandomPatch(BlockState blockstate) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)blockstate)));
    }

    public static RandomPatchConfiguration simpleRandomPatch(BlockStateProvider provider) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(provider));
    }

    private static RandomPatchConfiguration columnPlantWithFluid(int tries, int xzspread, int yspread, Block block, Fluid ... fluids) {
        return new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.filtered((Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)BlockColumnConfiguration.simple((IntProvider)BiasedToBottomInt.of((int)2, (int)4), (BlockStateProvider)BlockStateProvider.simple((Block)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO, (Block[])new Block[]{Blocks.AIR}), BlockPredicate.wouldSurvive((BlockState)block.defaultBlockState(), (Vec3i)BlockPos.ZERO), BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesFluids((Vec3i)new BlockPos(1, -1, 0), List.of(fluids)), BlockPredicate.matchesFluids((Vec3i)new BlockPos(1, -1, 0), List.of(fluids)), BlockPredicate.matchesFluids((Vec3i)new BlockPos(-1, -1, 0), List.of(fluids)), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, 1), List.of(fluids)), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, -1), List.of(fluids))})})));
    }

    private static RandomPatchConfiguration wildflower(PinkPetalsBlock block, int tries) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        return new RandomPatchConfiguration(tries, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder))));
    }
}

