/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal;

import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.BasaltDeltasRuinedPortalDecorator;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.CrimsonForestRuinedPortalDecorator;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.NetherWastesRuinedPortalDecorator;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.SoulSandValleyRuinedPortalDecorator;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.WarpedForestRuinedPortalDecorator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public abstract class RuinedPortalDecoratorBase {
    private String name;
    public static final List<RuinedPortalDecoratorBase> PORTAL_DECORATORS = new ArrayList<RuinedPortalDecoratorBase>();

    public RuinedPortalDecoratorBase(String name) {
        this.name = name;
    }

    @Nullable
    public abstract BlockState getTopSoil(WorldGenLevel var1, RandomSource var2);

    @Nullable
    public abstract BlockState getFillerSoil(WorldGenLevel var1, RandomSource var2);

    public abstract void decorate(WorldGenLevel var1, ChunkGenerator var2, RandomSource var3, BlockPos var4);

    public static void registerPortalDecorators() {
        PORTAL_DECORATORS.add(new NetherWastesRuinedPortalDecorator());
        PORTAL_DECORATORS.add(new SoulSandValleyRuinedPortalDecorator());
        PORTAL_DECORATORS.add(new BasaltDeltasRuinedPortalDecorator());
        PORTAL_DECORATORS.add(new CrimsonForestRuinedPortalDecorator());
        PORTAL_DECORATORS.add(new WarpedForestRuinedPortalDecorator());
    }

    public static RuinedPortalDecoratorBase getRandomPortalDecorator(RandomSource random) {
        int luckyNumber = random.nextInt(PORTAL_DECORATORS.size());
        return PORTAL_DECORATORS.get(luckyNumber);
    }

    public String toString() {
        return this.name;
    }
}

