/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.common.Tags;

public class HotSpringsFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public HotSpringsFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        RandomSource randomsource = pContext.random();
        ChunkGenerator generator = pContext.chunkGenerator();
        if (blockpos.getY() <= worldgenlevel.getMinBuildHeight() + 4) {
            return false;
        }
        blockpos = blockpos.below(4);
        boolean[] aboolean = new boolean[2048];
        int i = randomsource.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = randomsource.nextDouble() * 6.0 + 3.0;
            double d1 = randomsource.nextDouble() * 4.0 + 2.0;
            double d2 = randomsource.nextDouble() * 6.0 + 3.0;
            double d3 = randomsource.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = randomsource.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = randomsource.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState blockstate1 = Blocks.WATER.defaultBlockState();
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int k = 0; k < 16; ++k) {
                for (int l2 = 0; l2 < 8; ++l2) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && aboolean[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && aboolean[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && aboolean[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && aboolean[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && aboolean[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && aboolean[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (!flag) continue;
                    BlockState blockstate3 = worldgenlevel.getBlockState(blockpos.offset(k1, l2, k));
                    if (l2 >= 4 && blockstate3.liquid()) {
                        return false;
                    }
                    if (l2 >= 4 || blockstate3.isSolid() || worldgenlevel.getBlockState(blockpos.offset(k1, l2, k)) == blockstate1) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    BlockPos blockpos1;
                    if (!aboolean[(l1 * 16 + i2) * 8 + i3] || !this.canReplaceBlock(worldgenlevel.getBlockState(blockpos1 = blockpos.offset(l1, i3, i2)))) continue;
                    boolean flag1 = i3 >= 4;
                    worldgenlevel.setBlock(blockpos1, flag1 ? AIR : blockstate1, 2);
                    if (!flag1) continue;
                    worldgenlevel.scheduleTick(blockpos1, AIR.getBlock(), 0);
                    this.markAboveForPostProcessing(worldgenlevel, blockpos1);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int l3 = 0; l3 < 8; ++l3) {
                    BlockState blockstate;
                    boolean flag2;
                    boolean bl = flag2 = !aboolean[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && aboolean[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && aboolean[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && aboolean[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && aboolean[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && aboolean[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && aboolean[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                    if (!flag2 || l3 >= 4 && randomsource.nextInt(2) == 0 || !(blockstate = worldgenlevel.getBlockState(blockpos.offset(j2, l3, j3))).isSolid() || blockstate.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) continue;
                    BlockPos blockpos3 = blockpos.offset(j2, l3, j3);
                    if (!worldgenlevel.getFluidState(blockpos3.above()).is(Tags.Fluids.WATER)) {
                        if (worldgenlevel.isEmptyBlock(blockpos3.above()) || worldgenlevel.getBlockState(blockpos3.above()).canBeReplaced()) {
                            boolean flag4;
                            BlockState perimeterBlock = this.getRandomPerimeterBlock(randomsource);
                            worldgenlevel.setBlock(blockpos3, perimeterBlock, 2);
                            boolean bl2 = flag4 = randomsource.nextFloat() < 0.45f;
                            if (flag4) {
                                worldgenlevel.setBlock(blockpos3.above(), this.getAmethyst(randomsource), 2);
                            }
                        }
                    } else {
                        boolean flag5;
                        BlockState innerBlock = this.getRandomInnerBlock(randomsource);
                        worldgenlevel.setBlock(blockpos3, innerBlock, 2);
                        boolean bl3 = flag5 = randomsource.nextFloat() < 0.3f;
                        if (flag5) {
                            Optional watergrassFeature = worldgenlevel.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(AquaticFeatures.SEAGRASS_SIMPLE);
                            watergrassFeature.ifPresent(feature -> ((ConfiguredFeature)feature.value()).place(worldgenlevel, generator, randomsource, blockpos3.above()));
                        }
                    }
                    this.markAboveForPostProcessing(worldgenlevel, blockpos3);
                }
            }
        }
        return true;
    }

    private BlockState getRandomPerimeterBlock(RandomSource randomSource) {
        float random = randomSource.nextFloat();
        if (random < 0.3f) {
            return Blocks.STONE.defaultBlockState();
        }
        if (random < 0.5f) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        if (random < 0.7f) {
            return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
        return Blocks.PODZOL.defaultBlockState();
    }

    private BlockState getRandomInnerBlock(RandomSource randomSource) {
        float random = randomSource.nextFloat();
        if (random < 0.3f) {
            return Blocks.STONE.defaultBlockState();
        }
        if (random < 0.5f) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        if (random < 0.7f) {
            return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
        if (random < 0.83f) {
            return Blocks.MAGMA_BLOCK.defaultBlockState();
        }
        return Blocks.DIORITE.defaultBlockState();
    }

    private boolean canReplaceBlock(BlockState pState) {
        return !pState.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    private BlockState getAmethyst(RandomSource randomSource) {
        float random = randomSource.nextFloat();
        if (random <= 0.2f) {
            return Blocks.AMETHYST_CLUSTER.defaultBlockState();
        }
        if (random <= 0.2f) {
            return Blocks.LARGE_AMETHYST_BUD.defaultBlockState();
        }
        if (random <= 0.2f) {
            return Blocks.MEDIUM_AMETHYST_BUD.defaultBlockState();
        }
        return Blocks.SMALL_AMETHYST_BUD.defaultBlockState();
    }
}

