/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.platform.systems.energy;

import com.st0x0ef.stellaris.common.systems.energy.base.EnergySnapshot;
import com.st0x0ef.stellaris.common.systems.item.ItemStackHolder;
import com.st0x0ef.stellaris.common.systems.util.Serializable;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface EnergyContainer
extends Serializable,
Clearable {
    @Nullable
    public static EnergyContainer of(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return EnergyContainerHelper.of(level, pos, state, entity, direction);
    }

    @Nullable
    public static EnergyContainer of(Level level, BlockPos pos, @Nullable Direction direction) {
        return EnergyContainer.of(level, pos, null, null, direction);
    }

    @Nullable
    public static EnergyContainer of(BlockEntity block, @Nullable Direction direction) {
        return EnergyContainer.of(block.getLevel(), block.getBlockPos(), block.getBlockState(), block, direction);
    }

    @Nullable
    public static EnergyContainer of(ItemStackHolder holder) {
        return EnergyContainerHelper.of(holder);
    }

    public static boolean holdsEnergy(ItemStack stack) {
        return EnergyContainerHelper.holdsEnergy(stack);
    }

    public static boolean holdsEnergy(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return EnergyContainerHelper.holdsEnergy(level, pos, state, entity, direction);
    }

    public static boolean holdsEnergy(Level level, BlockPos pos, @Nullable Direction direction) {
        return EnergyContainer.holdsEnergy(level, pos, null, null, direction);
    }

    public static boolean holdsEnergy(BlockEntity block, @Nullable Direction direction) {
        return EnergyContainer.holdsEnergy(block.getLevel(), block.getBlockPos(), block.getBlockState(), block, direction);
    }

    public long insertEnergy(long var1, boolean var3);

    default public long internalInsert(long amount, boolean simulate) {
        return this.insertEnergy(amount, simulate);
    }

    public long extractEnergy(long var1, boolean var3);

    default public long internalExtract(long amount, boolean simulate) {
        return this.extractEnergy(amount, simulate);
    }

    public void setEnergy(long var1);

    public long getStoredEnergy();

    public long getMaxCapacity();

    public long maxInsert();

    public long maxExtract();

    public boolean allowsInsertion();

    public boolean allowsExtraction();

    public EnergySnapshot createSnapshot();

    default public void readSnapshot(EnergySnapshot snapshot) {
        snapshot.loadSnapshot(this);
    }
}

