/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.item;

import com.st0x0ef.stellaris.platform.systems.item.base.ItemContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlatformItemContainer(IItemHandler itemHandler) implements ItemContainer
{
    public static PlatformItemContainer of(@Nullable IItemHandler itemHandler) {
        return itemHandler == null ? null : new PlatformItemContainer(itemHandler);
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        ItemStack leftover = stack.copy();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!(leftover = this.itemHandler.insertItem(i, leftover, simulate)).isEmpty()) continue;
            return stack.copy();
        }
        return stack.copyWithCount(stack.getCount() - leftover.getCount());
    }

    @Override
    @NotNull
    public ItemStack insertIntoSlot(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack = this.itemHandler.insertItem(slot, stack, simulate);
        return itemStack.getCount() >= stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - itemStack.getCount());
    }

    @Override
    @NotNull
    public ItemStack extractItem(int amount, boolean simulate) {
        ItemStack extracted = ItemStack.EMPTY;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = this.itemHandler.extractItem(i, amount, simulate);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)extracted, (ItemStack)this.itemHandler.getStackInSlot(i))) {
                extracted.grow(this.itemHandler.extractItem(i, amount - extracted.getCount(), simulate).getCount());
            }
            if (extracted.getCount() >= amount) break;
        }
        return extracted;
    }

    @Override
    @NotNull
    public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.extractItem(i, this.itemHandler.getStackInSlot(i).getCount(), false);
        }
    }
}

