/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.item;

import com.st0x0ef.stellaris.common.systems.util.Updatable;
import com.st0x0ef.stellaris.platform.systems.item.base.ItemContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeItemContainer(ItemContainer container) implements IItemHandler
{
    public static ForgeItemContainer of(@Nullable ItemContainer container) {
        return container == null ? null : new ForgeItemContainer(container);
    }

    public int getSlots() {
        return this.container.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.container.getStackInSlot(i);
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean simulate) {
        ItemContainer itemContainer;
        ItemStack stack = this.container.insertIntoSlot(i, arg, simulate);
        if (!simulate && (itemContainer = this.container) instanceof Updatable) {
            Updatable updatable = (Updatable)((Object)itemContainer);
            updatable.update();
        }
        if (stack.getCount() >= arg.getCount()) {
            return ItemStack.EMPTY;
        }
        return arg.copyWithCount(arg.getCount() - stack.getCount());
    }

    @NotNull
    public ItemStack extractItem(int i, int j, boolean simulate) {
        ItemContainer itemContainer;
        ItemStack stack = this.container.extractFromSlot(i, j, simulate);
        if (!simulate && (itemContainer = this.container) instanceof Updatable) {
            Updatable updatable = (Updatable)((Object)itemContainer);
            updatable.update();
        }
        return stack;
    }

    public int getSlotLimit(int i) {
        return this.container.getSlotLimit(i);
    }

    public boolean isItemValid(int i, @NotNull ItemStack arg) {
        return this.container.isItemValid(i, arg);
    }
}

