/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.generic;

import com.st0x0ef.stellaris.common.systems.SystemsMain;
import com.st0x0ef.stellaris.common.systems.generic.base.EntityContainerLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class NeoForgeEntityContainerLookup<T, C>
implements EntityContainerLookup<T, C> {
    private final EntityCapability<T, C> capability;
    private final Map<Supplier<EntityType<?>>, EntityContainerLookup.EntityGetter<T, C>> blockEntityGetterMap = new HashMap();
    private Map<EntityType<?>, EntityContainerLookup.EntityGetter<T, C>> blockEntityMap = null;

    public NeoForgeEntityContainerLookup(EntityCapability<T, C> cap) {
        this.capability = cap;
    }

    public NeoForgeEntityContainerLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        this(EntityCapability.create((ResourceLocation)name, typeClass, contextClass));
    }

    @Override
    public T find(Entity stack, @Nullable C context) {
        return (T)stack.getCapability(this.capability, context);
    }

    @Override
    @SafeVarargs
    public final void registerEntityTypes(EntityContainerLookup.EntityGetter<T, C> getter, Supplier<EntityType<?>> ... containers) {
        for (Supplier<EntityType<?>> container : containers) {
            this.blockEntityGetterMap.put(container, getter);
        }
    }

    public void registerWithCaps(RegisterCapabilitiesEvent event) {
        this.getBlockEntityMap().forEach((blockEntityType, blockGetter) -> event.registerEntity(this.capability, blockEntityType, blockGetter::getContainer));
    }

    public Map<EntityType<?>, EntityContainerLookup.EntityGetter<T, C>> getBlockEntityMap() {
        this.blockEntityMap = SystemsMain.finalizeRegistration(this.blockEntityGetterMap, this.blockEntityMap);
        return this.blockEntityMap;
    }

    EntityCapability<T, C> getCapability() {
        return this.capability;
    }
}

