/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.generic;

import com.st0x0ef.stellaris.common.systems.SystemsMain;
import com.st0x0ef.stellaris.common.systems.generic.base.BlockContainerLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBlockContainerLookup<T, C>
implements BlockContainerLookup<T, C> {
    private final BlockCapability<T, @Nullable C> capability;
    private final Map<Supplier<Block>, BlockContainerLookup.BlockGetter<T, C>> blockGetterMap = new HashMap<Supplier<Block>, BlockContainerLookup.BlockGetter<T, C>>();
    private final Map<Supplier<BlockEntityType<?>>, BlockContainerLookup.BlockGetter<T, C>> blockEntityGetterMap = new HashMap();
    private Map<Block, BlockContainerLookup.BlockGetter<T, C>> blockMap = null;
    private Map<BlockEntityType<?>, BlockContainerLookup.BlockGetter<T, C>> blockEntityMap = null;

    public NeoForgeBlockContainerLookup(BlockCapability<T, C> cap) {
        this.capability = cap;
    }

    public NeoForgeBlockContainerLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        this(BlockCapability.create((ResourceLocation)name, typeClass, contextClass));
    }

    @Override
    @Nullable
    public T find(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable C direction) {
        return (T)level.getCapability(this.capability, pos, state, entity, direction);
    }

    @Override
    @SafeVarargs
    public final void registerBlocks(BlockContainerLookup.BlockGetter<T, C> getter, Supplier<Block> ... containers) {
        for (Supplier<Block> container : containers) {
            this.blockGetterMap.put(container, getter);
        }
    }

    @Override
    @SafeVarargs
    public final void registerBlockEntities(BlockContainerLookup.BlockGetter<T, C> getter, Supplier<BlockEntityType<?>> ... containers) {
        for (Supplier<BlockEntityType<?>> container : containers) {
            this.blockEntityGetterMap.put(container, getter);
        }
    }

    public void registerWithCaps(RegisterCapabilitiesEvent event) {
        this.getBlockMap().forEach((block, blockGetter) -> event.registerBlock(this.capability, blockGetter::getContainer, new Block[]{block}));
        this.getBlockEntityMap().forEach((blockEntityType, blockGetter) -> event.registerBlockEntity(this.capability, blockEntityType, (object, object2) -> blockGetter.getContainer(object.getLevel(), object.getBlockPos(), object.getBlockState(), (BlockEntity)object, object2)));
    }

    public Map<Block, BlockContainerLookup.BlockGetter<T, C>> getBlockMap() {
        this.blockMap = SystemsMain.finalizeRegistration(this.blockGetterMap, this.blockMap);
        return this.blockMap;
    }

    public Map<BlockEntityType<?>, BlockContainerLookup.BlockGetter<T, C>> getBlockEntityMap() {
        this.blockEntityMap = SystemsMain.finalizeRegistration(this.blockEntityGetterMap, this.blockEntityMap);
        return this.blockEntityMap;
    }

    BlockCapability<T, @Nullable C> getCapability() {
        return this.capability;
    }
}

