/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.energy;

import com.st0x0ef.stellaris.common.systems.util.Updatable;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainer;
import net.neoforged.neoforge.energy.IEnergyStorage;

public record ForgeEnergyContainer<T extends EnergyContainer & Updatable>(T container) implements IEnergyStorage
{
    public int receiveEnergy(int maxAmount, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (maxAmount <= 0) {
            return 0;
        }
        int inserted = (int)this.container.insertEnergy(Math.min((long)maxAmount, this.container.maxInsert()), bl);
        if (inserted > 0 && !bl) {
            ((Updatable)this.container).update();
        }
        return inserted;
    }

    public int extractEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int extracted = (int)this.container.extractEnergy(Math.min((long)maxAmount, this.container.maxExtract()), bl);
        if (extracted > 0 && !bl) {
            ((Updatable)this.container).update();
        }
        return extracted;
    }

    public int getEnergyStored() {
        return (int)this.container.getStoredEnergy();
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getMaxCapacity();
    }

    public boolean canExtract() {
        return this.container.allowsExtraction();
    }

    public boolean canReceive() {
        return this.container.allowsInsertion();
    }
}

