/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems;

import com.st0x0ef.stellaris.common.systems.energy.EnergyApi;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyBlock;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyItem;
import com.st0x0ef.stellaris.common.systems.item.ItemContainerBlock;
import com.st0x0ef.stellaris.common.systems.item.base.ItemBlock;
import com.st0x0ef.stellaris.neoforge.systems.energy.ForgeEnergyContainer;
import com.st0x0ef.stellaris.neoforge.systems.generic.NeoForgeCapsHandler;
import com.st0x0ef.stellaris.neoforge.systems.item.ForgeItemContainer;
import com.st0x0ef.stellaris.neoforge.systems.item.ItemContainerWrapper;
import com.st0x0ef.stellaris.platform.systems.item.base.ItemContainer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class SystemsNeoForge {
    public static void init(IEventBus bus) {
        bus.addListener(SystemsNeoForge::registerEnergy);
        bus.addListener(SystemsNeoForge::registerItem);
        bus.addListener(NeoForgeCapsHandler::registerCapabilities);
    }

    public static void registerItem(RegisterCapabilitiesEvent event) {
        BuiltInRegistries.BLOCK_ENTITY_TYPE.forEach(blockEntityType -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (blockEntity, object2) -> {
            if (blockEntity instanceof ItemContainerBlock) {
                ItemContainerBlock itemContainerBlock = (ItemContainerBlock)blockEntity;
                return new ItemContainerWrapper(itemContainerBlock.getContainer());
            }
            if (blockEntity instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)blockEntity;
                return new ForgeItemContainer((ItemContainer)itemBlock.getItemContainer(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), (BlockEntity)blockEntity, (Direction)object2));
            }
            return null;
        }));
        BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof ItemBlock).forEach(block -> event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
            Block patt0$temp = blockState.getBlock();
            if (patt0$temp instanceof ItemBlock) {
                ItemBlock itemContainerBlock = (ItemBlock)patt0$temp;
                return new ForgeItemContainer((ItemContainer)itemContainerBlock.getItemContainer(level, blockPos, blockState, blockEntity, (Direction)direction));
            }
            return null;
        }, new Block[]{block}));
    }

    public static void registerEnergy(RegisterCapabilitiesEvent event) {
        EnergyApi.getBlockEntityRegistry().forEach((blockEntityType, blockEnergyGetter1) -> event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (blockEntity, direction) -> new ForgeEnergyContainer(blockEnergyGetter1.getEnergyStorage(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), (BlockEntity)blockEntity, (Direction)direction))));
        EnergyApi.getBlockRegistry().forEach((block, blockEnergyGetter) -> event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> new ForgeEnergyContainer(blockEnergyGetter.getEnergyStorage(level, blockPos, blockState, blockEntity, (Direction)direction)), new Block[]{block}));
        EnergyApi.getItemRegistry().forEach((item, itemEnergyGetter) -> event.registerItem(Capabilities.EnergyStorage.ITEM, (itemStack, unused) -> {
            Object energyContainer = itemEnergyGetter.getEnergyStorage((ItemStack)itemStack);
            if (energyContainer != null) {
                return new ForgeEnergyContainer(energyContainer);
            }
            return null;
        }, new ItemLike[]{item}));
        BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof EnergyBlock).forEach(block -> event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
            Block patt0$temp = blockState.getBlock();
            if (patt0$temp instanceof EnergyBlock) {
                EnergyBlock energyBlock = (EnergyBlock)patt0$temp;
                return new ForgeEnergyContainer(energyBlock.getEnergyStorage(level, blockPos, blockState, blockEntity, (Direction)direction));
            }
            return null;
        }, new Block[]{block}));
        BuiltInRegistries.BLOCK_ENTITY_TYPE.forEach(blockEntityType -> event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (blockEntity, direction) -> {
            if (blockEntity instanceof EnergyBlock) {
                EnergyBlock energyBlock = (EnergyBlock)blockEntity;
                return new ForgeEnergyContainer(energyBlock.getEnergyStorage(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), (BlockEntity)blockEntity, (Direction)direction));
            }
            return null;
        }));
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof EnergyItem).forEach(item -> event.registerItem(Capabilities.EnergyStorage.ITEM, (itemStack, unused) -> {
            EnergyItem energyItem = (EnergyItem)item;
            return new ForgeEnergyContainer(energyItem.getEnergyStorage((ItemStack)itemStack));
        }, new ItemLike[]{item}));
    }
}

