/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.st0x0ef.stellaris.client.renderers.armors.JetSuitModel;
import com.st0x0ef.stellaris.client.renderers.armors.SpaceSuitModel;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.items.armors.JetSuit;
import com.st0x0ef.stellaris.common.items.armors.SpaceSuit;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class RenderPlayerMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    protected abstract void setModelProperties(AbstractClientPlayer var1);

    public RenderPlayerMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/model/geom/ModelPart;Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderPlayerHand(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, ModelPart renderedArm, ModelPart rendererArmwear, CallbackInfo ci) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack.getItem() instanceof JetSuit.Suit || stack.getItem() instanceof AbstractSpaceArmor) {
            boolean isRightHand;
            ci.cancel();
            PlayerModel playerModel = (PlayerModel)this.getModel();
            this.setModelProperties(player);
            playerModel.attackTime = 0.0f;
            playerModel.crouching = false;
            playerModel.swimAmount = 0.0f;
            playerModel.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            renderedArm.xRot = 0.0f;
            ResourceLocation texture = null;
            HumanoidModel model = null;
            if (stack.getItem() instanceof JetSuit.Suit) {
                ModelLayerLocation layer = JetSuitModel.LAYER_LOCATION;
                texture = JetSuitModel.TEXTURE;
                ModelPart rootPart = Minecraft.getInstance().getEntityModels().bakeLayer(layer);
                model = new JetSuitModel(rootPart, EquipmentSlot.CHEST, stack, null);
            } else if (stack.getItem() instanceof AbstractSpaceArmor) {
                ModelLayerLocation layer = SpaceSuitModel.LAYER_LOCATION;
                ModelPart rootPart = Minecraft.getInstance().getEntityModels().bakeLayer(layer);
                texture = SpaceSuitModel.TEXTURE;
                model = new SpaceSuitModel(rootPart, EquipmentSlot.CHEST, stack, null);
            }
            boolean bl = isRightHand = renderedArm == model.rightArm;
            if (isRightHand) {
                model.rightArm.copyFrom(renderedArm);
                model.rightArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), packedLight, OverlayTexture.NO_OVERLAY);
            } else {
                model.leftArm.copyFrom(renderedArm);
                model.leftArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    @Inject(method={"render*(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderPlayer(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        Item item;
        if (entity.getVehicle() instanceof LanderEntity) {
            ci.cancel();
        }
        if (Utils.isLivingInSpaceSuit((LivingEntity)entity) && (item = entity.getItemBySlot(EquipmentSlot.CHEST).getItem()) instanceof SpaceSuit) {
            SpaceSuit spaceSuitItem = (SpaceSuit)item;
            ItemStack spaceSuitStack = entity.getItemBySlot(EquipmentSlot.CHEST);
            spaceSuitItem.getModules(spaceSuitStack).forEach(module -> module.renderModel(poseStack, buffer, entity, entityYaw, partialTicks, packedLight));
        }
    }
}

