/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.vehicle_upgrade;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public class FuelType {
    public static final Codec<Type> CODEC = StringRepresentable.fromEnum(Type::values);

    @Deprecated
    public static float getMegametersTraveled(int fuelQuantity, Item fuelItem) {
        Type type = Type.getTypeBasedOnItem(fuelItem);
        return FuelType.getMegametersTraveled(fuelQuantity, type);
    }

    public static float getMegametersTraveled(int fuelQuantity, Type type) {
        if (type != null) {
            return switch (type.ordinal()) {
                case 0 -> 19.22f * (float)fuelQuantity;
                case 1 -> 21.36f * (float)fuelQuantity;
                case 2, 3 -> 23.74f * (float)fuelQuantity;
                case 4 -> 26.38f * (float)fuelQuantity;
                case 5 -> 29.3f * (float)fuelQuantity;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
            };
        }
        return 0.0f;
    }

    @Deprecated
    public static float getFuelNeededToGoOnPlanet(Planet actual, Planet destination, Item fuelItem) {
        Type type = Type.getTypeBasedOnItem(fuelItem);
        return FuelType.getFuelNeededToGoOnPlanet(actual, destination, type);
    }

    public static float getFuelNeededToGoOnPlanet(Planet actual, Planet destination, Type type) {
        float distance = Mth.abs((int)(actual.distanceFromEarth() - destination.distanceFromEarth()));
        if (type != null) {
            return switch (type.ordinal()) {
                case 0 -> distance / 19.22f;
                case 1 -> distance / 21.36f;
                case 2, 3 -> distance / 23.74f;
                case 4 -> distance / 26.38f;
                case 5 -> distance / 29.3f;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
            };
        }
        return 0.0f;
    }

    public static Item getItemBasedOnTypeName(String name) {
        if (name.equals(Type.FUEL.getSerializedName())) {
            return (Item)ItemsRegistry.FUEL_BUCKET.get();
        }
        if (name.equals(Type.HYDROGEN.getSerializedName())) {
            return (Item)ItemsRegistry.HYDROGEN_BUCKET.get();
        }
        if (name.equals(Type.URANIUM.getSerializedName())) {
            return (Item)ItemsRegistry.URANIUM_INGOT.get();
        }
        if (name.equals(Type.NEPTUNIUM.getSerializedName())) {
            return (Item)ItemsRegistry.NEPTUNIUM_INGOT.get();
        }
        if (name.equals(Type.PLUTONIUM.getSerializedName())) {
            return (Item)ItemsRegistry.PLUTONIUM_INGOT.get();
        }
        return null;
    }

    public static Item getItemBasedOnLoacation(ResourceLocation location) {
        return (Item)ItemsRegistry.ITEMS.getRegistrar().get(location);
    }

    public static enum Type implements StringRepresentable
    {
        FUEL(GUISprites.FUEL_OVERLAY, null),
        HYDROGEN(GUISprites.HYDROGEN_OVERLAY, null),
        RADIOACTIVE(GUISprites.ENERGY_FULL, null),
        URANIUM(GUISprites.ENERGY_FULL, RADIOACTIVE),
        NEPTUNIUM(GUISprites.ENERGY_FULL, RADIOACTIVE),
        PLUTONIUM(GUISprites.ENERGY_FULL, RADIOACTIVE);

        private final ResourceLocation fuelTexture;
        private final Type motorType;

        private Type(ResourceLocation fuelTexture, Type motorType) {
            this.fuelTexture = fuelTexture;
            this.motorType = motorType;
        }

        public static Type getTypeBasedOnItem(Item item) {
            if (item == null) {
                return null;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.FUEL_BUCKET.get())) {
                return FUEL;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                return HYDROGEN;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.URANIUM_INGOT.get())) {
                return URANIUM;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.NEPTUNIUM_INGOT.get())) {
                return NEPTUNIUM;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.PLUTONIUM_INGOT.get())) {
                return PLUTONIUM;
            }
            return null;
        }

        public static Type fromString(String name) {
            return switch (name) {
                case "fuel" -> FUEL;
                case "hydrogen" -> HYDROGEN;
                case "uranium" -> URANIUM;
                case "neptunium" -> NEPTUNIUM;
                case "plutonium" -> PLUTONIUM;
                case "radioactive" -> RADIOACTIVE;
                default -> null;
            };
        }

        public Type getMotorType() {
            if (this.motorType == null) {
                return this;
            }
            return this.motorType;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public ResourceLocation getFuelTexture() {
            return this.fuelTexture;
        }
    }
}

