/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import com.st0x0ef.stellaris.common.utils.Rectangle2d;
import dev.architectury.fluid.FluidStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import org.joml.Matrix4f;

public class GuiHelper {
    public static final ResourceLocation FLUID_TANK_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/fluid_tank_overlay.png");
    public static final ResourceLocation OXYGEN_CONTENT_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/oxygen.png");
    public static final int OXYGEN_TANK_WIDTH = 12;
    public static final int OXYGEN_TANK_HEIGHT = 46;
    public static final ResourceLocation HYDROGEN_CONTENT_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/hydrogen.png");
    public static final int HYDROGEN_TANK_WIDTH = 12;
    public static final int HYDROGEN_TANK_HEIGHT = 46;
    public static final ResourceLocation ENERGY_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/energy_full.png");
    public static final int ENERGY_WIDTH = 13;
    public static final int ENERGY_HEIGHT = 46;
    public static final int FUEL_WIDTH = 48;
    public static final int FUEL_HEIGHT = 48;
    public static final ResourceLocation FLUID_TANK_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/fluid_tank_overlay.png");
    public static final int FLUID_TANK_WIDTH = 12;
    public static final int FLUID_TANK_HEIGHT = 46;
    public static final ResourceLocation ARROW_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/arrow_full.png");
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final ResourceLocation HAMMER_PATH = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/hammer_full.png");
    public static final int HAMMER_WIDTH = 16;
    public static final int HAMMER_HEIGHT = 16;
    private static final ResourceLocation MISSING_TEXTURE_LOCATION = ResourceLocation.parse((String)"missingno");

    public static boolean isHover(Rectangle2d bounds, double x, double y) {
        int left = bounds.getX();
        int right = left + bounds.getWidth();
        int top = bounds.getY();
        int bottom = top + bounds.getHeight();
        return (double)left <= x && x < (double)right && (double)top <= y && y < (double)bottom;
    }

    public static void drawArrow(GuiGraphics graphics, int left, int top, double ratio) {
        GuiHelper.drawHorizontal(graphics, left, top, 24, 17, ARROW_PATH, ratio);
    }

    public static void drawHammer(GuiGraphics graphics, int left, int top, double ratio) {
        GuiHelper.drawHorizontal(graphics, left, top, 16, 16, HAMMER_PATH, ratio);
    }

    public static Rectangle2d getArrowBounds(int left, int top) {
        return new Rectangle2d(left, top, 24, 17);
    }

    public static void drawEnergy(GuiGraphics graphics, int left, int top, WrappedBlockEnergyContainer energyStorage) {
        GuiHelper.drawEnergy(graphics, left, top, (double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity());
    }

    public static void drawEnergy(GuiGraphics graphics, int left, int top, double ratio) {
        GuiHelper.drawVertical(graphics, left, top, 13, 46, ENERGY_PATH, ratio);
    }

    public static void drawFuel(GuiGraphics matrixStack, int left, int top, double ratio) {
        ResourceLocation full = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/rocket_fuel_bar_full.png");
        GuiHelper.drawVertical(matrixStack, left, top, 48, 48, full, ratio);
    }

    public static Rectangle2d getEnergyBounds(int left, int top) {
        return new Rectangle2d(left, top, 13, 46);
    }

    public static Rectangle2d getBounds(int left, int top, int width, int height) {
        return new Rectangle2d(left, top, width, height);
    }

    public static void drawTiledSprite(GuiGraphics graphics, int left, int top, int width, int height, TextureAtlasSprite sprite, int tileWidth, int tileHeight) {
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        GuiHelper.drawTiledSprite(graphics, left, top, width, height, tileWidth, tileHeight, uMin, uMax, vMin, vMax);
    }

    public static void drawTiledSprite(GuiGraphics graphics, int left, int top, int width, int height, int tileWidth, int tileHeight, float uMin, float uMax, float vMin, float vMax) {
        Matrix4f matrix = graphics.pose().last().pose();
        int xTileCount = width / tileWidth;
        int xRemainder = width - xTileCount * tileWidth;
        int yTileCount = height / tileWidth;
        int yRemainder = height - yTileCount * tileWidth;
        int yStart = top + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tiledWidth = xTile == xTileCount ? xRemainder : tileWidth;
                int tiledHeight = yTile == yTileCount ? yRemainder : tileWidth;
                int x = left + xTile * tileWidth;
                int y = yStart - (yTile + 1) * tileHeight;
                if (tiledWidth <= 0 || tiledHeight <= 0) continue;
                int maskRight = tileWidth - tiledWidth;
                int maskTop = tileHeight - tiledHeight;
                GuiHelper.drawTextureWithMasking(matrix, x, y, tileWidth, tileHeight, maskTop, maskRight, 0.0f, uMin, uMax, vMin, vMax);
            }
        }
    }

    public static void drawTextureWithMasking(Matrix4f matrix, float left, float top, float tileWidth, float tileHeight, int maskTop, int maskRight, float zLevel, float uMin, float uMax, float vMin, float vMax) {
        uMax -= (float)maskRight / tileWidth * (uMax - uMin);
        vMax -= (float)maskTop / tileHeight * (vMax - vMin);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, left, top + tileHeight, zLevel).setUv(uMin, vMax);
        bufferBuilder.addVertex(matrix, left + tileWidth - (float)maskRight, top + tileHeight, zLevel).setUv(uMax, vMax);
        bufferBuilder.addVertex(matrix, left + tileWidth - (float)maskRight, top + (float)maskTop, zLevel).setUv(uMax, vMin);
        bufferBuilder.addVertex(matrix, left, top + (float)maskTop, zLevel).setUv(uMin, vMin);
        bufferBuilder.buildOrThrow();
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static TextureAtlasSprite getStillFluidSprite(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MISSING_TEXTURE_LOCATION);
    }

    public static Rectangle2d getFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 12, 46);
    }

    public static Rectangle2d getRocketFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 48, 48);
    }

    public static void drawVertical(GuiGraphics graphics, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        graphics.blit(resource, left, top + remainHeight, 0.0f, (float)remainHeight, width, ratioHeight, width, height);
    }

    public static void drawVerticalReverse(GuiGraphics graphics, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        graphics.blit(resource, left, top, 0.0f, 0.0f, width, remainHeight, width, height);
    }

    public static void drawHorizontal(GuiGraphics graphics, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        graphics.blit(resource, left, top, 0.0f, 0.0f, ratioWidth, height, width, height);
    }

    public static void drawHorizontalReverse(GuiGraphics graphics, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        int remainWidth = width - ratioWidth;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        graphics.blit(resource, left + ratioWidth, top, (float)ratioWidth, 0.0f, remainWidth, height, width, height);
    }

    public static void innerBlit(Matrix4f matrix, float x1, float x2, float y1, float y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, x1, y2, (float)blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, x2, y2, (float)blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, x2, y1, (float)blitOffset).setUv(maxU, minV);
        bufferBuilder.addVertex(matrix, x1, y1, (float)blitOffset).setUv(minU, minV);
        bufferBuilder.buildOrThrow();
    }

    public static void blit(PoseStack matrixStack, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void innerBlit(PoseStack matrixStack, float x1, float x2, float y1, float y2, int blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack.last().pose(), x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + vHeight) / (float)textureHeight);
    }

    public static void blit(PoseStack matrixStack, float x, float y, float uOffset, float vOffset, float width, float height, int textureWidth, int textureHeight) {
        GuiHelper.blit(matrixStack, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    private GuiHelper() {
    }
}

