/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.st0x0ef.stellaris.common.data_components.CappedLongComponent;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class FuelUtils {
    public static boolean addFuel(ItemStack stack, long amount) {
        if (!stack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get()) || FuelUtils.getFuel(stack) + amount > FuelUtils.getFuelCapacity(stack)) {
            return false;
        }
        FuelUtils.setFuel(stack, FuelUtils.getFuel(stack) + amount);
        return true;
    }

    public static boolean removeFuel(ItemStack stack, long amount) {
        if (!stack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get()) || FuelUtils.getFuel(stack) < amount) {
            return false;
        }
        FuelUtils.setFuel(stack, FuelUtils.getFuel(stack) - amount);
        return true;
    }

    public static void setFuel(ItemStack stack, long amount) {
        long newAmount = Math.clamp(amount, 0L, FuelUtils.getFuelCapacity(stack));
        stack.set((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get(), (Object)new CappedLongComponent(newAmount, ((CappedLongComponent)stack.get((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())).capacity()));
    }

    public static long getFuel(ItemStack stack) {
        if (stack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())) {
            return ((CappedLongComponent)stack.get((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())).amount();
        }
        return 0L;
    }

    public static long getFuelCapacity(ItemStack stack) {
        if (stack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())) {
            return ((CappedLongComponent)stack.get((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())).capacity();
        }
        return 0L;
    }
}

