/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.systems.item.impl;

import com.st0x0ef.stellaris.common.systems.item.base.ItemContainerExtras;
import com.st0x0ef.stellaris.common.systems.item.base.ItemSnapshot;
import com.st0x0ef.stellaris.common.systems.util.Serializable;
import com.st0x0ef.stellaris.common.systems.util.Snapshotable;
import com.st0x0ef.stellaris.platform.systems.item.base.ItemContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class SimpleItemContainer
implements ItemContainer,
ItemContainerExtras,
Serializable,
Snapshotable<ItemSnapshot> {
    private final NonNullList<ItemStack> stacks;
    private Runnable onUpdate = () -> {};

    public SimpleItemContainer(int capacity) {
        this.stacks = NonNullList.withSize((int)capacity, (Object)ItemStack.EMPTY);
    }

    public SimpleItemContainer(int capacity, ItemStack stack) {
        this(capacity);
    }

    public SimpleItemContainer(int capacity, Level level, BlockPos blockPos) {
        this(capacity);
        this.onUpdate = () -> {
            BlockEntity blockEntity;
            if (level != null && (blockEntity = level.getBlockEntity(blockPos)) != null) {
                blockEntity.setChanged();
            }
        };
    }

    public SimpleItemContainer(int capacity, BlockEntity blockEntity) {
        this(capacity);
        this.onUpdate = () -> ((BlockEntity)blockEntity).setChanged();
    }

    public SimpleItemContainer(int capacity, Runnable onUpdate) {
        this(capacity);
        this.onUpdate = onUpdate;
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).getMaxStackSize();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || !this.isItemValid(0, stack)) {
            return ItemStack.EMPTY;
        }
        int insertedAmount = 0;
        ItemStack initial = stack.copy();
        for (int i = 0; i < this.stacks.size(); ++i) {
            stack = stack.copyWithCount(stack.getCount() - (insertedAmount += this.insertIntoSlot(i, stack, simulate).getCount()));
            if (insertedAmount >= initial.getCount()) break;
        }
        return insertedAmount == 0 ? ItemStack.EMPTY : initial.copyWithCount(insertedAmount);
    }

    @Override
    @NotNull
    public ItemStack insertIntoSlot(int slot, @NotNull ItemStack stack, boolean simulate) {
        int amount;
        if (stack.isEmpty() || !this.isItemValid(slot, stack)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = ((ItemStack)this.stacks.get(slot)).copy();
        if (itemStack.isEmpty()) {
            int amount2 = Math.min(stack.getCount(), this.getSlotLimit(slot));
            if (!simulate) {
                this.stacks.set(slot, (Object)stack.copyWithCount(amount2));
            }
            return stack.copyWithCount(amount2);
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) && (amount = Math.min(stack.getCount(), this.getSlotLimit(slot) - itemStack.getCount())) > 0) {
            if (!simulate) {
                itemStack.grow(amount);
                this.stacks.set(slot, (Object)itemStack);
            }
            return stack.copyWithCount(amount);
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int amount, boolean simulate) {
        ItemStack extracted = ItemStack.EMPTY;
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            int toExtract = Math.min(amount - extracted.getCount(), stack.getCount());
            if (extracted.isEmpty()) {
                extracted = stack.copyWithCount(toExtract);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)extracted, (ItemStack)stack)) {
                extracted.grow(toExtract);
            }
            if (!simulate) {
                stack.shrink(toExtract);
                this.stacks.set(i, (Object)stack);
            }
            if (extracted.getCount() >= amount) break;
        }
        return extracted;
    }

    @Override
    @NotNull
    public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, stack.getCount());
        ItemStack extracted = stack.copyWithCount(toExtract);
        if (!simulate) {
            this.stacks.set(slot, (Object)((ItemStack)this.stacks.get(slot)).copyWithCount(stack.getCount() - toExtract));
        }
        return extracted;
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void clearContent() {
        this.stacks.clear();
    }

    @Override
    public void deserialize(CompoundTag nbt) {
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        return null;
    }

    @Override
    public SimpleItemSnapshot createSnapshot() {
        return new SimpleItemSnapshot();
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public class SimpleItemSnapshot
    implements ItemSnapshot {
        CompoundTag tag;

        public SimpleItemSnapshot() {
            this.tag = SimpleItemContainer.this.serialize(new CompoundTag());
        }

        @Override
        public void loadSnapshot() {
            SimpleItemContainer.this.stacks.clear();
            SimpleItemContainer.this.deserialize(this.tag);
        }
    }
}

