/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.registry;

import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import dev.architectury.core.fluid.ArchitecturyFlowingFluid;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.SimpleArchitecturyFluidAttributes;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;

public class FluidRegistry {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((String)"stellaris", (ResourceKey)Registries.FLUID);
    public static final List<ArchitecturyFluidAttributes> FLUIDS_INFOS = new ArrayList<ArchitecturyFluidAttributes>();
    public static final ArchitecturyFluidAttributes FUEL_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_FUEL, () -> FUEL_STILL).blockSupplier(() -> BlocksRegistry.FUEL_BLOCK).bucketItemSupplier(() -> ItemsRegistry.FUEL_BUCKET).slopeFindDistance(4).dropOff(1).tickDelay(8).explosionResistance(100.0f).luminosity(3).convertToSource(false).sourceTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/fuel_still")).flowingTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/fuel_flow"));
    public static final RegistrySupplier<FlowingFluid> FLOWING_FUEL = FLUIDS.register("flowing_fuel", () -> new ArchitecturyFlowingFluid.Flowing(FUEL_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> FUEL_STILL = FLUIDS.register("fuel", () -> new ArchitecturyFlowingFluid.Source(FUEL_ATTRIBUTES));
    public static final ArchitecturyFluidAttributes OIL_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_OIL, () -> OIL_STILL).blockSupplier(() -> BlocksRegistry.OIL_BLOCK).bucketItemSupplier(() -> ItemsRegistry.OIL_BUCKET).slopeFindDistance(4).dropOff(1).tickDelay(8).explosionResistance(100.0f).convertToSource(true).sourceTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/oil_still")).flowingTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/oil_flow"));
    public static final RegistrySupplier<FlowingFluid> FLOWING_OIL = FLUIDS.register("flowing_oil", () -> new ArchitecturyFlowingFluid.Flowing(OIL_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> OIL_STILL = FLUIDS.register("oil", () -> new ArchitecturyFlowingFluid.Source(OIL_ATTRIBUTES));
    public static final ArchitecturyFluidAttributes HYDROGEN_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_HYDROGEN, () -> HYDROGEN_STILL).blockSupplier(() -> BlocksRegistry.HYDROGEN_BLOCK).bucketItemSupplier(() -> ItemsRegistry.HYDROGEN_BUCKET).slopeFindDistance(4).dropOff(1).tickDelay(8).explosionResistance(100.0f).convertToSource(false).sourceTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/hydrogen_still")).flowingTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/hydrogen_flow"));
    public static final RegistrySupplier<FlowingFluid> FLOWING_HYDROGEN = FLUIDS.register("flowing_hydrogen", () -> new ArchitecturyFlowingFluid.Flowing(HYDROGEN_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> HYDROGEN_STILL = FLUIDS.register("hydrogen", () -> new ArchitecturyFlowingFluid.Source(HYDROGEN_ATTRIBUTES));
    public static final ArchitecturyFluidAttributes OXYGEN_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_OXYGEN, () -> OXYGEN_STILL).blockSupplier(() -> BlocksRegistry.OXYGEN_BLOCK).slopeFindDistance(4).dropOff(1).tickDelay(8).explosionResistance(100.0f).convertToSource(false).sourceTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/oxygen_still")).flowingTexture(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"block/fluids/oxygen_flow"));
    public static final RegistrySupplier<FlowingFluid> FLOWING_OXYGEN = FLUIDS.register("flowing_oxygen", () -> new ArchitecturyFlowingFluid.Flowing(OXYGEN_ATTRIBUTES));
    public static final RegistrySupplier<FlowingFluid> OXYGEN_STILL = FLUIDS.register("oxygen", () -> new ArchitecturyFlowingFluid.Source(OXYGEN_ATTRIBUTES));

    public static void init() {
        FLUIDS.register();
        FLUIDS_INFOS.add(OXYGEN_ATTRIBUTES);
        FLUIDS_INFOS.add(OIL_ATTRIBUTES);
        FLUIDS_INFOS.add(HYDROGEN_ATTRIBUTES);
        FLUIDS_INFOS.add(FUEL_ATTRIBUTES);
    }
}

