/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.oxygen.DimensionOxygenManager;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OxygenRoom {
    private final BlockPos distributorPos;
    private final Set<BlockPos> oxygenatedPositions;
    private final Queue<BlockPos> positionsToCheck;
    private final ServerLevel level;
    private final DimensionOxygenManager oxygenManager;
    private static final int HALF_ROOM_SIZE = 16;

    public OxygenRoom(ServerLevel level, BlockPos distributorPos) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = new LinkedHashSet<BlockPos>();
        this.positionsToCheck = new LinkedList<BlockPos>();
        this.level = level;
        this.oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level);
    }

    public BlockPos getDistributorPosition() {
        return this.distributorPos;
    }

    public OxygenDistributorBlockEntity getDistributorBlockEntity() {
        OxygenDistributorBlockEntity distributor;
        BlockEntity blockEntity = this.level.getBlockEntity(this.distributorPos);
        return blockEntity instanceof OxygenDistributorBlockEntity ? (distributor = (OxygenDistributorBlockEntity)blockEntity) : null;
    }

    public void updateOxygenRoom() {
        this.positionsToCheck.clear();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (Direction direction : Direction.values()) {
            this.positionsToCheck.offer(this.distributorPos.relative(direction));
        }
        while (!this.positionsToCheck.isEmpty()) {
            OxygenDistributorBlockEntity distributor;
            BlockPos currentPos = this.positionsToCheck.poll();
            visited.add(currentPos);
            if (!this.isAirBlock(currentPos) || (distributor = this.getDistributorBlockEntity()) == null || distributor.oxygenTank.getAmount() <= 0L || distributor.getWrappedEnergyContainer().getStoredEnergy() <= 0L) continue;
            for (int x = -16; x <= 16; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -16; z <= 16; ++z) {
                        BlockPos pos = this.distributorPos.offset(x, y, z);
                        this.oxygenatedPositions.add(pos);
                        distributor.getWrappedEnergyContainer().extractEnergy(3L, false);
                    }
                }
            }
            distributor.setChanged();
            break;
        }
    }

    public void removeOxygenInRoom() {
        this.oxygenatedPositions.clear();
    }

    public boolean hasOxygenAt(BlockPos pos) {
        return this.oxygenatedPositions.contains(pos);
    }

    private boolean isAirBlock(BlockPos pos) {
        return this.level.getBlockState(pos).isAir();
    }

    public boolean breathOxygenAt(BlockPos pos) {
        if (this.hasOxygenAt(pos)) {
            OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
            if (distributor != null && distributor.useOxygenAndEnergy()) {
                distributor.setChanged();
                return true;
            }
            this.oxygenatedPositions.remove(pos);
        }
        return false;
    }
}

