/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.oxygen.OxygenRoom;
import com.st0x0ef.stellaris.common.oxygen.OxygenSavedData;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.OxygenUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DimensionOxygenManager {
    private final Set<OxygenRoom> oxygenRooms = new HashSet<OxygenRoom>();
    private final Map<BlockPos, OxygenRoom> roomToCheckIfOpen = new HashMap<BlockPos, OxygenRoom>();
    private final boolean planetHasOxygen;
    private final ServerLevel level;

    public DimensionOxygenManager(ServerLevel level) {
        this.level = level;
        this.planetHasOxygen = PlanetUtil.hasOxygen((Level)level);
    }

    public void addOxygenRoomIfMissing(BlockPos distributorPos) {
        if (this.getOxygenRoom(distributorPos) == null) {
            this.oxygenRooms.add(new OxygenRoom(this.level, distributorPos));
            this.updateOxygen();
            this.setChanged();
        }
    }

    public void removeOxygenRoom(BlockPos pos) {
        this.oxygenRooms.removeIf(room -> room.getDistributorPosition().equals((Object)pos));
        this.setChanged();
    }

    public void addRoomToCheckIfOpen(BlockPos pos, OxygenRoom room) {
        if (this.checkIfRoomOpen(pos)) {
            this.roomToCheckIfOpen.put(pos, room);
        }
    }

    public boolean checkIfRoomOpen(BlockPos pos) {
        return this.roomToCheckIfOpen.remove(pos) == null;
    }

    private void setChanged() {
        OxygenSavedData data = OxygenSavedData.getData(this.level);
        data.setDirty();
    }

    public void updateOxygen() {
        if (this.planetHasOxygen) {
            return;
        }
        this.oxygenRooms.forEach(OxygenRoom::updateOxygenRoom);
        this.roomToCheckIfOpen.values().forEach(OxygenRoom::removeOxygenInRoom);
        this.roomToCheckIfOpen.clear();
    }

    public boolean breath(LivingEntity entity) {
        Player player;
        if (this.planetHasOxygen || entity.getType().is(TagRegistry.ENTITY_NO_OXYGEN_NEEDED_TAG)) {
            return true;
        }
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            return true;
        }
        if (this.breathOxygenAt(entity.getOnPos().above())) {
            return true;
        }
        if (Utils.isLivingInJetSuit(entity) || Utils.isLivingInSpaceSuit(entity)) {
            return OxygenUtils.removeOxygen(entity.getItemBySlot(EquipmentSlot.CHEST), FluidTankHelper.convertFromNeoMb(1L));
        }
        return false;
    }

    public boolean breathOxygenAt(BlockPos pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.breathOxygenAt(pos));
    }

    public boolean hasOxygenAt(BlockPos pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.hasOxygenAt(pos));
    }

    public Set<OxygenRoom> getOxygenRooms() {
        return this.oxygenRooms;
    }

    public OxygenRoom getOxygenRoom(BlockPos distributorPos) {
        return this.oxygenRooms.stream().filter(room -> room.getDistributorPosition().equals((Object)distributorPos)).findFirst().orElse(null);
    }

    public void setOxygensRooms(Set<OxygenRoom> rooms) {
        this.oxygenRooms.clear();
        this.oxygenRooms.addAll(rooms);
        this.updateOxygen();
    }
}

