/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterPumpBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.network.packets.SyncWidgetsTanksPacket;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WaterPumpMenu
extends BaseContainer {
    private final ContainerLevelAccess access;
    private final WaterPumpBlockEntity blockEntity;

    public WaterPumpMenu(int containerId, Inventory inventory, ContainerLevelAccess access, WaterPumpBlockEntity blockEntity) {
        super((MenuType)MenuTypesRegistry.WATER_PUMP_MENU.get(), containerId, 0, inventory, 0);
        this.access = access;
        this.blockEntity = blockEntity;
    }

    public static WaterPumpMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        WaterPumpBlockEntity blockEntity = (WaterPumpBlockEntity)inventory.player.level().getBlockEntity(pos);
        return new WaterPumpMenu(containerId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)pos), blockEntity);
    }

    @Override
    public boolean stillValid(Player player) {
        if (!player.isLocalPlayer()) {
            this.syncWidgets((ServerPlayer)player);
        }
        return (Boolean)this.access.evaluate((level, pos) -> level.getBlockState(pos).is((Block)BlocksRegistry.WATER_PUMP.get()) && player.canInteractWithBlock(pos, 4.0), (Object)true);
    }

    public WaterPumpBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void syncWidgets(ServerPlayer player) {
        if (!player.level().isClientSide()) {
            FluidTank tank = this.blockEntity.getWaterTank();
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{tank.getAmount()}, new ResourceLocation[]{tank.getStack().getFluid().arch$registryName()}));
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{this.blockEntity.getWrappedEnergyContainer().getStoredEnergy(), 0L}));
        }
    }
}

