/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.menus.slot.SpecificItemsSlot;
import com.st0x0ef.stellaris.common.menus.slot.VacumatorCanSlot;
import com.st0x0ef.stellaris.common.menus.slot.VacumatorFoodSlot;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class VacuumatorMenu
extends AbstractContainerMenu {
    private final Container container;

    public VacuumatorMenu(int syncId, Inventory inventory, FriendlyByteBuf buffer) {
        this(syncId, inventory, (Container)new SimpleContainer(5));
    }

    public VacuumatorMenu(int syncId, Inventory inventory, Container container) {
        super((MenuType)MenuTypesRegistry.VACUMATOR_MENU.get(), syncId);
        VacuumatorMenu.checkContainerSize((Container)container, (int)5);
        this.container = container;
        this.addSlot(new VacumatorCanSlot(container, 0, 36, 56));
        this.addSlot(new VacumatorFoodSlot(container, 1, 80, 48));
        this.addSlot(new SpecificItemsSlot.Item(container, 2, 124, 56, Items.GLASS_BOTTLE));
        this.addSlot(new ResultSlot(container, 3, 58, 96));
        this.addSlot(new ResultSlot(container, 4, 102, 96));
        this.addPlayerHotbar(inventory);
        this.addPlayerInventory(inventory);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.container.getContainerSize() ? !this.moveItemStackTo(originalStack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18 + 58));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 200));
        }
    }
}

