/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.SolarPanelEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.network.packets.SyncWidgetsTanksPacket;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainer;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class SolarPanelMenu
extends BaseContainer {
    private final Container inventory;
    private final SolarPanelEntity entity;

    public static SolarPanelMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        SolarPanelEntity entity = (SolarPanelEntity)inventory.player.level().getBlockEntity(data.readBlockPos());
        return new SolarPanelMenu(syncId, inventory, (Container)new SimpleContainer(1), entity);
    }

    public SolarPanelMenu(int syncId, Inventory playerInventory, Container container, SolarPanelEntity entity) {
        super((MenuType)MenuTypesRegistry.SOLAR_PANEL_MENU.get(), syncId, 1, playerInventory, 22);
        SolarPanelMenu.checkContainerSize((Container)container, (int)1);
        this.inventory = container;
        this.entity = entity;
        this.addSlot(new Slot(this.inventory, 0, 38, 44));
    }

    public SolarPanelEntity getBlockEntity() {
        return this.entity;
    }

    @Override
    public boolean stillValid(Player player) {
        if (!player.isLocalPlayer()) {
            this.syncBattery((ServerPlayer)player);
        }
        return this.inventory.stillValid(player);
    }

    public EnergyContainer getEnergyContainer() {
        return this.entity.getWrappedEnergyContainer();
    }

    public void syncBattery(ServerPlayer player) {
        if (!player.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{this.getEnergyContainer().getStoredEnergy()}));
        }
    }
}

