/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.entities.vehicles.RoverEntity;
import com.st0x0ef.stellaris.common.menus.IVehicleMenu;
import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.menus.slot.VehicleFuelSlot;
import com.st0x0ef.stellaris.common.menus.slot.upgrade.MotorUpgradeSlot;
import com.st0x0ef.stellaris.common.menus.slot.upgrade.SpeedUpgradeSlot;
import com.st0x0ef.stellaris.common.menus.slot.upgrade.TankUpgradeSlot;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RoverMenu
extends AbstractContainerMenu
implements IVehicleMenu {
    private final Container inventory;
    private final RoverEntity rover;

    public RoverMenu(int syncId, Inventory inventory, FriendlyByteBuf buffer) {
        this(syncId, inventory, (Container)new SimpleContainer(13), buffer.readVarInt());
    }

    public RoverMenu(int syncId, Inventory playerInventory, Container container, int entityId) {
        super((MenuType)MenuTypesRegistry.ROVER_MENU.get(), syncId);
        this.rover = (RoverEntity)playerInventory.player.level().getEntity(entityId);
        RoverMenu.checkContainerSize((Container)container, (int)13);
        this.inventory = container;
        this.addSlots(this.inventory);
        this.addPlayerHotbar(playerInventory);
        this.addPlayerInventory(playerInventory);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        if (!player.isLocalPlayer()) {
            this.getRover().syncRocketData((ServerPlayer)player);
        }
        return this.inventory.stillValid(player);
    }

    private void addSlots(Container inventory) {
        this.addSlot(new VehicleFuelSlot(inventory, 0, 20, 27));
        this.addSlot(new ResultSlot(inventory, 1, 20, 57));
        this.addSlot(new MotorUpgradeSlot(inventory, 2, 88, 66, this.rover));
        this.addSlot(new SpeedUpgradeSlot(inventory, 3, 114, 66));
        this.addSlot(new TankUpgradeSlot(inventory, 4, 140, 66));
        this.addSlot(new Slot(inventory, 5, 86, 20));
        this.addSlot(new Slot(inventory, 6, 86, 38));
        this.addSlot(new Slot(inventory, 7, 104, 20));
        this.addSlot(new Slot(inventory, 8, 104, 38));
        this.addSlot(new Slot(inventory, 9, 122, 20));
        this.addSlot(new Slot(inventory, 10, 122, 38));
        this.addSlot(new Slot(inventory, 11, 140, 20));
        this.addSlot(new Slot(inventory, 12, 140, 38));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18 + 11));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 153));
        }
    }

    public RoverEntity getRover() {
        return this.rover;
    }

    @Override
    public int getFuel() {
        return this.getRover().getFuel();
    }
}

