/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.module;

import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.data_components.CappedLongComponent;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.utils.FuelUtils;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FuelModule
extends Item
implements SpaceSuitModule {
    public FuelModule(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public MutableComponent displayName() {
        return Component.translatable((String)"spacesuit.stellaris.fuel_module");
    }

    @Override
    public void renderToGui(GuiGraphics graphics, DeltaTracker deltaTracker, Player player, ItemStack stack) {
        graphics.blit(GUISprites.SPACESUIT_FUEL_BAR, 5, 16, 0.0f, 0.0f, 37, 10, 37, 10);
        int i = Mth.ceil((float)(Mth.clamp((float)((float)FuelUtils.getFuel(stack) / (float)FuelUtils.getFuelCapacity(stack)), (float)0.0f, (float)1.0f) * 23.0f));
        graphics.blitSprite(GUISprites.SPACESUIT_FULL_BAR_SPRITE, 24, 4, 0, 0, 15, 19, i, 4);
    }

    @Override
    public void addToTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!stack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get())) {
            stack.set((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get(), (Object)new CappedLongComponent(0L, FluidTankHelper.BUCKET_AMOUNT * 10L));
        }
        tooltipComponents.add((Component)Component.translatable((String)"jetsuit.stellaris.fuel", (Object[])new Object[]{FuelUtils.getFuel(stack)}).append(" \u00a7r/\u00a78 " + FuelUtils.getFuelCapacity(stack)));
    }
}

