/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.st0x0ef.stellaris.common.data_components.SpaceSuitModules;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SpaceSuit
extends AbstractSpaceArmor.AbstractSpaceChestplate {
    public SpaceSuit(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player && (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof SpaceSuit) {
            ItemStack spaceSuitItemStack = player.getItemBySlot(EquipmentSlot.CHEST);
            List<SpaceSuitModule> modules = this.getModules(stack);
            if (!modules.isEmpty()) {
                modules.forEach(spaceSuitModule -> spaceSuitModule.tick(spaceSuitItemStack, level, player));
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List<SpaceSuitModule> modules = this.getModules(stack);
        if (!modules.isEmpty()) {
            modules.forEach(spaceSuitModule -> spaceSuitModule.addToTooltips(stack, context, tooltipComponents, tooltipFlag));
        }
        if (Screen.hasShiftDown()) {
            if (!modules.isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"spacesuit.stellaris.modules"));
                modules.forEach(spaceSuitModule -> tooltipComponents.add((Component)spaceSuitModule.displayName().withStyle(ChatFormatting.GRAY)));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"spacesuit.stellaris.shift_for_modules"));
        }
    }

    public NonNullList<ItemStack> scrapArmorModules(ItemStack stack) {
        Iterable<ItemStack> items = ((SpaceSuitModules)stack.getOrDefault((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)new SpaceSuitModules(List.of()))).itemsCopy();
        NonNullList itemsToReturn = NonNullList.create();
        items.forEach(arg_0 -> itemsToReturn.add(arg_0));
        stack.set((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)SpaceSuitModules.empty());
        return itemsToReturn;
    }

    public List<SpaceSuitModule> getModules(ItemStack stack) {
        return ((SpaceSuitModules)stack.getOrDefault((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)SpaceSuitModules.empty())).getModules();
    }
}

