/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.common.data_components.RoverComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.RoverEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoverItem
extends Item {
    public RoverItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        ItemStack itemStack = context.getItemInHand();
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            RoverEntity rover = this.getRover(context.getLevel(), itemStack);
            rover.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            if (level2.addFreshEntity((Entity)rover)) {
                if (!player.getAbilities().instabuild) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                level2.addFreshEntity((Entity)rover);
                this.roverPlaceSound(pos, (Level)level2);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public RoverEntity getRover(Level level, ItemStack stack) {
        RoverEntity rover = new RoverEntity((EntityType)EntityRegistry.ROVER.get(), level);
        RoverComponent roverComponent = (RoverComponent)stack.get((DataComponentType)DataComponentsRegistry.ROVER_COMPONENT.get());
        if (roverComponent != null) {
            rover.setRoverComponent(new RoverComponent(roverComponent.fuelType(), Math.max(roverComponent.fuel(), 0), roverComponent.getFuelType().getFuelTexture(), rover.tankUpgrade.getTankCapacity(), rover.speedUpgrade.getSpeedModifier()));
        }
        return rover;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        RoverComponent rocketComponent = (RoverComponent)stack.get((DataComponentType)DataComponentsRegistry.ROVER_COMPONENT.get());
        if (rocketComponent == null) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.rocket.fuel", (Object[])new Object[]{rocketComponent.fuel()}).withStyle(ChatFormatting.GRAY));
    }

    public void roverPlaceSound(BlockPos pos, Level world) {
        world.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        RoverComponent roverComponent = (RoverComponent)stack.get((DataComponentType)DataComponentsRegistry.ROVER_COMPONENT.get());
        return 13 * roverComponent.fuel() / roverComponent.getTankCapacity();
    }

    public int getBarColor(ItemStack stack) {
        RoverComponent roverComponent = (RoverComponent)stack.get((DataComponentType)DataComponentsRegistry.ROVER_COMPONENT.get());
        FuelType.Type type = roverComponent.getFuelType();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FUEL", "HYDROGEN", "RADIOACTIVE", "URANIUM", "NEPTUNIUM", "PLUTONIUM"}, (FuelType.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> 11003629;
            case 1 -> 55551;
            case 2, 3, 4, 5 -> 49455;
            case -1 -> 11003629;
        };
    }
}

