/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.data_components.CappedLongComponent;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.utils.OxygenUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OxygenTankItem
extends Item {
    public OxygenTankItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get())) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.stellaris.oxygen_tank", (Object[])new Object[]{OxygenUtils.getOxygen(stack), OxygenUtils.getOxygenCapacity(stack)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            return super.use(level, player, usedHand);
        }
        if (player.isShiftKeyDown() && player.getItemBySlot(EquipmentSlot.CHEST).has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get())) {
            ItemStack armor = player.getItemBySlot(EquipmentSlot.CHEST);
            Stellaris.LOG.info("ee");
            ItemStack tank = player.getItemInHand(usedHand);
            CappedLongComponent oxygenComponent = (CappedLongComponent)tank.get((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get());
            if (oxygenComponent.amount() == 0L) {
                return super.use(level, player, usedHand);
            }
            long oxygenToFill = OxygenUtils.getOxygenCapacity(armor) - OxygenUtils.getOxygen(armor);
            if (oxygenToFill >= oxygenComponent.amount()) {
                OxygenUtils.addOxygen(armor, oxygenComponent.amount());
                OxygenUtils.setOxygen(tank, 0L);
            } else {
                OxygenUtils.addOxygen(armor, oxygenToFill);
                OxygenUtils.addOxygen(tank, -oxygenToFill);
            }
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity block = context.getLevel().getBlockEntity(context.getClickedPos());
        if (block instanceof OxygenDistributorBlockEntity) {
            OxygenDistributorBlockEntity entity = (OxygenDistributorBlockEntity)block;
            ItemStack stack = context.getItemInHand();
            if (stack.has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get())) {
                entity.addOyxgen(OxygenUtils.getOxygen(stack));
                OxygenUtils.setOxygen(stack, 0L);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        long storedOxygen = OxygenUtils.getOxygen(stack);
        return (int)Mth.clamp((long)((13L + storedOxygen * 13L) / OxygenUtils.getOxygenCapacity(stack)), (long)0L, (long)13L);
    }

    public int getBarColor(ItemStack stack) {
        return 11003629;
    }
}

