/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class OilFinderItem
extends Item {
    public OilFinderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide()) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
        }
        int oilLevel = level.getChunk(player.getOnPos()).stellaris$getChunkOilLevel();
        MutableComponent component = Component.literal((String)("Found Oil " + level.getChunk(player.getOnPos()).stellaris$getChunkOilLevel() + "mb"));
        if (FluidTankHelper.convertToNeoMb(oilLevel) > 40000) {
            component.withColor(Utils.getColorHexCode("green"));
        } else if (FluidTankHelper.convertToNeoMb(oilLevel) > 0) {
            component.withColor(Utils.getColorHexCode("orange"));
        } else {
            component = Component.literal((String)"No oil found");
            component.withColor(Utils.getColorHexCode("red"));
        }
        player.getItemInHand(usedHand).hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.displayClientMessage((Component)component, true);
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.oil_finder").withStyle(ChatFormatting.GRAY));
    }
}

