/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CanItem
extends Item {
    private final int maxNutrition;

    public CanItem(Item.Properties properties, int maxNutrition) {
        super(properties);
        this.maxNutrition = maxNutrition;
    }

    public static void setFoodProperties(ItemStack stack, FoodProperties foodProperties) {
        stack.set(DataComponents.FOOD, (Object)foodProperties);
    }

    public static FoodProperties getFoodProperties(ItemStack stack) {
        return (FoodProperties)stack.get(DataComponents.FOOD);
    }

    public static int getNutrition(ItemStack stack) {
        FoodProperties properties = CanItem.getFoodProperties(stack);
        return properties != null ? properties.nutrition() : 0;
    }

    public static float getSaturation(ItemStack stack) {
        FoodProperties properties = CanItem.getFoodProperties(stack);
        return properties != null ? properties.saturation() : 0.0f;
    }

    public static boolean addFoodToCan(ItemStack canStack, ItemStack foodStack) {
        int canNutrition = CanItem.getNutrition(canStack) + CanItem.getNutrition(foodStack);
        if (canNutrition <= ((CanItem)canStack.getItem()).getMaxNutrition()) {
            CanItem.setFoodProperties(canStack, new FoodProperties(canNutrition, (float)Math.round((CanItem.getSaturation(canStack) + CanItem.getSaturation(foodStack)) * 10.0f) / 10.0f, false, 1.6f, Optional.empty(), List.of()));
            return true;
        }
        return false;
    }

    public int getMaxNutrition() {
        return this.maxNutrition;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FoodProperties properties = CanItem.getFoodProperties(stack);
        if (properties == null || properties.nutrition() <= 0 && properties.saturation() <= 0.0f) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.stellaris.can.empty").withStyle(ChatFormatting.GRAY));
            return;
        }
        if (properties.nutrition() > 0) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.stellaris.can.nutrition", (Object[])new Object[]{properties.nutrition(), this.getMaxNutrition()}).withStyle(ChatFormatting.GRAY));
        }
        if (properties.saturation() > 0.0f) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.stellaris.can.saturation", (Object[])new Object[]{Float.valueOf(properties.saturation())}).withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        ItemStack emptyCanStack = new ItemStack((ItemLike)stack.getItem());
        super.finishUsingItem(stack, level, entity);
        if (entity instanceof Player && !(player = (Player)entity).hasInfiniteMaterials()) {
            if (stack.isEmpty()) {
                return emptyCanStack;
            }
            if (!player.getInventory().add(emptyCanStack)) {
                player.drop(emptyCanStack, false);
            }
        }
        return stack;
    }
}

