/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterSeparatorBlockEntity;
import com.st0x0ef.stellaris.common.data.recipes.input.FluidInput;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record WaterSeparatorRecipe(FluidStack ingredientStack, List<FluidStack> resultStacks, boolean isMb, long energy) implements Recipe<FluidInput>
{
    public boolean matches(FluidInput container, Level level) {
        FluidStack stack = ((WaterSeparatorBlockEntity)container.entity()).getIngredientTank().getStack();
        return stack.isFluidEqual(this.ingredientStack) && stack.getAmount() >= this.ingredientStack.getAmount();
    }

    public ItemStack assemble(FluidInput container, HolderLookup.Provider registries) {
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.WATER_SEPERATOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.WATER_SEPERATOR_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<WaterSeparatorRecipe> {
        private static final MapCodec<WaterSeparatorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("ingredient").forGetter(WaterSeparatorRecipe::ingredientStack), (App)FluidStack.CODEC.listOf(1, 2).fieldOf("results").forGetter(WaterSeparatorRecipe::resultStacks), (App)Codec.BOOL.optionalFieldOf("isFluidMB").forGetter(recipe -> Optional.of(recipe.isMb)), (App)Codec.LONG.fieldOf("energy").forGetter(WaterSeparatorRecipe::energy)).apply((Applicative)instance, (ingredientStack, resultStacks, isFluidMb, energy) -> {
            boolean isMb = isFluidMb.orElse(true);
            Serializer.convertFluidStack(ingredientStack, isMb);
            resultStacks.forEach(stack -> Serializer.convertFluidStack(stack, isMb));
            return new WaterSeparatorRecipe((FluidStack)ingredientStack, (List<FluidStack>)resultStacks, isMb, (long)energy);
        }));
        public static final StreamCodec<RegistryFriendlyByteBuf, List<FluidStack>> FLUID_STACK_LIST_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)FluidStack.STREAM_CODEC, (int)2);
        private static final StreamCodec<RegistryFriendlyByteBuf, WaterSeparatorRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            recipe.ingredientStack().write(buf);
            FLUID_STACK_LIST_STREAM_CODEC.encode(buf, recipe.resultStacks);
            buf.writeBoolean(recipe.isMb);
            buf.writeLong(recipe.energy);
        }, buf -> new WaterSeparatorRecipe(FluidStack.read((RegistryFriendlyByteBuf)buf), (List)FLUID_STACK_LIST_STREAM_CODEC.decode(buf), buf.readBoolean(), buf.readLong()));

        public static void convertFluidStack(FluidStack stack, boolean isMb) {
            if (isMb) {
                stack.setAmount(FluidTankHelper.convertFromNeoMb(stack.getAmount()));
            }
        }

        public MapCodec<WaterSeparatorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaterSeparatorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

