/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FuelRefineryBlockEntity;
import com.st0x0ef.stellaris.common.data.recipes.WaterSeparatorRecipe;
import com.st0x0ef.stellaris.common.data.recipes.input.FluidInput;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import dev.architectury.fluid.FluidStack;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record FuelRefineryRecipe(FluidStack ingredientStack, FluidStack resultStack, boolean isMb, long energy) implements Recipe<FluidInput>
{
    public boolean matches(FluidInput input, Level level) {
        FluidStack stack = ((FuelRefineryBlockEntity)input.entity()).getIngredientTank().getStack();
        return stack.isFluidEqual(this.ingredientStack) && stack.getAmount() >= this.ingredientStack.getAmount();
    }

    public ItemStack assemble(FluidInput input, HolderLookup.Provider registries) {
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.FUEL_REFINERY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.FUEL_REFINERY_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FuelRefineryRecipe> {
        private static final MapCodec<FuelRefineryRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("ingredient").forGetter(FuelRefineryRecipe::ingredientStack), (App)FluidStack.CODEC.fieldOf("result").forGetter(FuelRefineryRecipe::resultStack), (App)Codec.BOOL.optionalFieldOf("isFluidMB").forGetter(recipe -> Optional.of(recipe.isMb)), (App)Codec.LONG.fieldOf("energy").forGetter(FuelRefineryRecipe::energy)).apply((Applicative)instance, (ingredientStack, resultStack, isFluidMb, energy) -> {
            boolean isMb = isFluidMb.orElse(true);
            WaterSeparatorRecipe.Serializer.convertFluidStack(ingredientStack, isMb);
            WaterSeparatorRecipe.Serializer.convertFluidStack(resultStack, isMb);
            return new FuelRefineryRecipe((FluidStack)ingredientStack, (FluidStack)resultStack, isMb, (long)energy);
        }));
        private static final StreamCodec<RegistryFriendlyByteBuf, FuelRefineryRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            recipe.ingredientStack().write(buf);
            recipe.resultStack().write(buf);
            buf.writeBoolean(recipe.isMb());
            buf.writeLong(recipe.energy());
        }, buf -> new FuelRefineryRecipe(FluidStack.read((RegistryFriendlyByteBuf)buf), FluidStack.read((RegistryFriendlyByteBuf)buf), buf.readBoolean(), buf.readLong()));

        public MapCodec<FuelRefineryRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FuelRefineryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

