/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WrappedFluidBlockEntity;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class WaterPumpBlockEntity
extends BaseEnergyBlockEntity
implements WrappedFluidBlockEntity {
    private static final long NEEDED_ENERGY = 100L;
    private final FluidTank waterTank = new FluidTank("waterTank", 3L);

    public WaterPumpBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.WATER_PUMP.get(), pos, state);
    }

    @Override
    public int getMaxCapacity() {
        return 1000;
    }

    @Override
    public void tick() {
        WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
        if (energyContainer.getStoredEnergy() >= 100L) {
            BlockPos belowPos = this.worldPosition.below();
            BlockState belowState = this.level.getBlockState(belowPos);
            FluidState belowFluidState = this.level.getFluidState(belowPos);
            if (belowFluidState.is((Fluid)Fluids.WATER) && belowFluidState.isSource()) {
                BucketPickup bucketPickup;
                Block block;
                if (this.waterTank.isEmpty()) {
                    BucketPickup bucketPickup2;
                    Block block2 = belowState.getBlock();
                    if (block2 instanceof BucketPickup && !(bucketPickup2 = (BucketPickup)block2).pickupBlock(null, (LevelAccessor)this.level, belowPos, belowState).isEmpty()) {
                        this.waterTank.setFluid((Fluid)Fluids.WATER, FluidTankHelper.BUCKET_AMOUNT);
                        energyContainer.extractEnergy(100L, false);
                        this.setChanged();
                    }
                } else if (this.waterTank.getAmount() + FluidTankHelper.BUCKET_AMOUNT <= this.waterTank.getMaxCapacity() && (block = belowState.getBlock()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)this.level, belowPos, belowState).isEmpty()) {
                    FluidTankHelper.addToTank(this.waterTank, FluidStack.create((Fluid)Fluids.WATER, (long)FluidTankHelper.BUCKET_AMOUNT));
                    energyContainer.extractEnergy(100L, false);
                    this.setChanged();
                }
            }
        }
        FluidTankHelper.transferFluidNearby(this, this.waterTank);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.waterTank.load(provider, tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.waterTank.save(provider, tag);
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    @Override
    public FluidTank[] getFluidTanks() {
        return new FluidTank[]{this.waterTank};
    }
}

