/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.ImplementedInventory;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.items.CanItem;
import com.st0x0ef.stellaris.common.menus.VacuumatorMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VacuumatorBlockEntity
extends BaseContainerBlockEntity
implements ImplementedInventory,
TickingBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public VacuumatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.VACUUMATOR_ENTITY.get(), blockPos, blockState);
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new VacuumatorMenu(i, inventory, (Container)this);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.vacuumator");
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    @Override
    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    @Override
    public void tick() {
        if (this.canCraft()) {
            this.craft();
            this.setChanged();
        }
    }

    public boolean canCraft() {
        if (this.getItem(0).getItem() instanceof CanItem) {
            return VacuumatorBlockEntity.isFood(this.getItem(1)) && this.getItem(2).is(Items.GLASS_BOTTLE) && this.getItem(3).isEmpty() && this.getItem(4).isEmpty();
        }
        return false;
    }

    public void craft() {
        ItemStack canStack = this.getItem(0);
        ItemStack resultStack = new ItemStack((ItemLike)canStack.getItem());
        CanItem.setFoodProperties(resultStack, CanItem.getFoodProperties(canStack));
        if (CanItem.addFoodToCan(resultStack, this.getItem(1))) {
            for (int i = 0; i < 3; ++i) {
                if (this.getItem(i).getCount() < 1) continue;
                this.removeItem(i, 1);
            }
            this.setItem(3, resultStack);
            this.setItem(4, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER));
        }
    }

    public static boolean isFood(ItemStack food) {
        return food.has(DataComponents.FOOD);
    }

    @Override
    public int getContainerSize() {
        return 5;
    }
}

