/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WrappedFluidBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.CoalGeneratorBlock;
import com.st0x0ef.stellaris.common.menus.PumpjackMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public class PumpjackBlockEntity
extends BaseEnergyContainerBlockEntity
implements WrappedFluidBlockEntity {
    private boolean isGenerating = false;
    private final long oilToExtract = FluidTankHelper.convertFromNeoMb(10);
    public final FluidTank resultTank = new FluidTank("resultTank", 5L);
    public int chunkOilLevel = 0;

    public PumpjackBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.PUMPJACK.get(), pos, state);
    }

    @Override
    public void tick() {
        FluidTankHelper.extractFluidToItem(this, this.resultTank, 0, 1);
        ChunkAccess access = this.level.getChunk(this.worldPosition);
        this.chunkOilLevel = access.stellaris$getChunkOilLevel();
        WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
        int actualOilToExtract = (int)this.oilToExtract;
        if ((long)access.stellaris$getChunkOilLevel() < this.oilToExtract && (actualOilToExtract = access.stellaris$getChunkOilLevel()) == 0) {
            return;
        }
        if (energyContainer.getStoredEnergy() >= 2L * (long)actualOilToExtract) {
            if (this.resultTank.getAmount() + (long)actualOilToExtract <= this.resultTank.getMaxCapacity()) {
                access.stellaris$setChunkOilLevel(access.stellaris$getChunkOilLevel() - actualOilToExtract);
                FluidStack tankStack = this.resultTank.getStack();
                if (tankStack.isEmpty()) {
                    this.resultTank.setFluid(FluidRegistry.OIL_ATTRIBUTES.getSourceFluid(), actualOilToExtract);
                } else {
                    this.resultTank.grow(actualOilToExtract);
                }
                energyContainer.extractEnergy(2L * (long)actualOilToExtract, false);
                this.isGenerating = true;
                this.setChanged();
            } else {
                this.isGenerating = false;
            }
        }
        if (this.isGenerating) {
            state = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(true));
            this.level.setBlock(this.getBlockPos(), state, 3);
        } else {
            state = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(false));
            this.level.setBlock(this.getBlockPos(), state, 3);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.pumpjack");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new PumpjackMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    @Override
    protected int getMaxCapacity() {
        return 6000;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.resultTank.load(provider, tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.resultTank.save(provider, tag);
    }

    public FluidTank getResultTank() {
        return this.resultTank;
    }

    public int chunkOilLevel() {
        return this.chunkOilLevel;
    }

    @Override
    public FluidTank[] getFluidTanks() {
        return new FluidTank[]{this.resultTank};
    }
}

