/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WrappedFluidBlockEntity;
import com.st0x0ef.stellaris.common.menus.OxygenDistributorMenu;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.OxygenUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class OxygenDistributorBlockEntity
extends BaseEnergyContainerBlockEntity
implements WrappedFluidBlockEntity {
    public final FluidTank oxygenTank = new FluidTank("oxygenTank", 10L);

    public OxygenDistributorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.OXYGEN_DISTRIBUTOR.get(), pos, state);
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getItem(0).has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get()) && this.oxygenTank.canGrow(1L) && this.getWrappedEnergyContainer().getStoredEnergy() > 1L && OxygenUtils.removeOxygen(this.getItem(0), 1L)) {
                this.addOyxgen(1L);
                this.getWrappedEnergyContainer().extractEnergy(1L, false);
            }
            if (this.oxygenTank.getAmount() > 0L) {
                GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel).addOxygenRoomIfMissing(this.getBlockPos());
            }
        }
    }

    public boolean useOxygenAndEnergy() {
        if ((this.oxygenTank.getStack().isEmpty() || this.oxygenTank.getAmount() == 0L) && this.getItem(0).has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get()) && this.getWrappedEnergyContainer().getStoredEnergy() > 0L && OxygenUtils.removeOxygen(this.getItem(0), 1L)) {
            this.getWrappedEnergyContainer().extractEnergy(1L, false);
            return true;
        }
        if (this.oxygenTank.getAmount() > 0L && this.getWrappedEnergyContainer().getStoredEnergy() > 0L) {
            this.oxygenTank.shrink(1L);
            this.getWrappedEnergyContainer().extractEnergy(1L, false);
            return true;
        }
        return false;
    }

    public void addOyxgen(long amount) {
        if (this.oxygenTank.getStack().isEmpty()) {
            this.oxygenTank.setFluid(FluidRegistry.OXYGEN_ATTRIBUTES.getSourceFluid(), amount);
        } else {
            this.oxygenTank.grow(amount);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.oxygen_distributor");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new OxygenDistributorMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.oxygenTank.load(provider, tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.oxygenTank.save(provider, tag);
    }

    @Override
    public FluidTank[] getFluidTanks() {
        return new FluidTank[]{this.oxygenTank};
    }
}

