/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WrappedFluidBlockEntity;
import com.st0x0ef.stellaris.common.data_components.CappedLongComponent;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.FuelUtils;
import com.st0x0ef.stellaris.common.utils.OxygenUtils;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidTankHelper {
    public static final long BUCKET_AMOUNT = FluidStackHooks.bucketAmount();

    public static <T extends BlockEntity> void extractFluidToItem(T blockEntity, FluidTank tank, int slot) {
        ItemStack inputStack = ((Container)blockEntity).getItem(slot);
        if (!inputStack.isEmpty() && !tank.isEmpty()) {
            boolean isTank = inputStack.has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get());
            if (tank.getAmount() >= BUCKET_AMOUNT || isTank && !tank.isEmpty()) {
                ItemStack stack;
                ItemStack resultStack = ItemStack.EMPTY;
                if (isTank && tank.getStack().getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get())) {
                    resultStack = inputStack.copy();
                    long storedOxygen = OxygenUtils.getOxygen(inputStack);
                    if (storedOxygen + 1L >= OxygenUtils.getOxygenCapacity(inputStack)) {
                        return;
                    }
                    if (OxygenUtils.getOxygenCapacity(inputStack) - storedOxygen > (long)FluidTankHelper.convertFromNeoMb(10) && tank.getAmount() > (long)FluidTankHelper.convertFromNeoMb(10)) {
                        OxygenUtils.addOxygen(resultStack, FluidTankHelper.convertFromNeoMb(10));
                        tank.shrink(FluidTankHelper.convertFromNeoMb(10));
                    } else if (tank.getAmount() < (long)FluidTankHelper.convertFromNeoMb(10) && storedOxygen + tank.getAmount() <= OxygenUtils.getOxygenCapacity(inputStack)) {
                        OxygenUtils.addOxygen(resultStack, tank.getAmount());
                        tank.shrink(tank.getAmount());
                    } else if (tank.getAmount() > OxygenUtils.getOxygenCapacity(inputStack) - storedOxygen) {
                        OxygenUtils.addOxygen(resultStack, OxygenUtils.getOxygenCapacity(inputStack) - storedOxygen);
                        tank.shrink(OxygenUtils.getOxygenCapacity(inputStack) - storedOxygen);
                    }
                } else if (!isTank && FluidTankHelper.isEmptyBucket(inputStack.getItem()) && !(stack = new ItemStack((ItemLike)tank.getStack().getFluid().getBucket())).isEmpty() && !FluidTankHelper.isEmptyBucket(stack.getItem())) {
                    resultStack = stack;
                    tank.shrink(BUCKET_AMOUNT);
                }
                if (!resultStack.isEmpty()) {
                    ((Container)blockEntity).setItem(slot, resultStack);
                    blockEntity.setChanged();
                }
            }
        }
    }

    public static boolean isEmptyBucket(Item item) {
        BucketItem bucketItem;
        return item instanceof BucketItem && FluidBucketHooks.getFluid((BucketItem)(bucketItem = (BucketItem)item)).isSame(Fluids.EMPTY);
    }

    public static <T extends BlockEntity> void extractFluidToItem(T blockEntity, FluidTank tank, int inputSlot, int outputSlot) {
        boolean hasSpace;
        ItemStack outputStack = ((Container)blockEntity).getItem(outputSlot);
        ItemStack inputStack = ((Container)blockEntity).getItem(inputSlot);
        boolean bl = hasSpace = outputStack.getCount() < outputStack.getMaxStackSize();
        if (!inputStack.isEmpty() && (outputStack.isEmpty() || hasSpace)) {
            boolean canFuel = inputStack.has((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get());
            if (!tank.isEmpty() && (tank.getAmount() >= BUCKET_AMOUNT || canFuel)) {
                ItemStack resultStack = ItemStack.EMPTY;
                if (FluidTankHelper.isEmptyBucket(inputStack.getItem())) {
                    resultStack = new ItemStack((ItemLike)tank.getStack().getFluid().getBucket());
                } else if (canFuel) {
                    resultStack = inputStack.copy();
                }
                if (!resultStack.isEmpty()) {
                    boolean success = false;
                    long amount = BUCKET_AMOUNT;
                    if (outputStack.isEmpty()) {
                        ((Container)blockEntity).setItem(outputSlot, resultStack);
                        success = true;
                    } else if (ItemStack.isSameItem((ItemStack)outputStack, (ItemStack)resultStack) && hasSpace) {
                        outputStack.grow(1);
                        success = true;
                    }
                    if (success) {
                        if (canFuel) {
                            long fuel = FuelUtils.getFuel(inputStack);
                            amount = Math.min(FuelUtils.getFuelCapacity(inputStack) - fuel, tank.getAmount());
                            resultStack.set((DataComponentType)DataComponentsRegistry.STORED_FUEL_COMPONENT.get(), (Object)new CappedLongComponent(Mth.clamp((long)(fuel + amount), (long)0L, (long)FuelUtils.getFuelCapacity(inputStack)), FuelUtils.getFuelCapacity(inputStack)));
                        }
                        inputStack.shrink(1);
                        tank.shrink(amount);
                        blockEntity.setChanged();
                    }
                }
            }
        }
    }

    public static void addToTank(FluidTank tank, FluidStack stack) {
        FluidStack tankStack = tank.getStack();
        if (tankStack.isEmpty()) {
            tank.setFluid(stack.getFluid(), stack.getAmount());
        } else if (tank.getStack().isFluidEqual(stack)) {
            tank.grow(stack.getAmount());
        }
    }

    public static <T extends BlockEntity> boolean addFluidFromBucket(T blockEntity, FluidTank tank, int inputSlot, int outputSlot) {
        if (tank.getAmount() + BUCKET_AMOUNT < tank.getMaxCapacity()) {
            Item item;
            boolean hasSpace;
            ItemStack inputStack = ((Container)blockEntity).getItem(inputSlot);
            ItemStack outputStack = ((Container)blockEntity).getItem(outputSlot);
            boolean bl = hasSpace = outputStack.getCount() < outputStack.getMaxStackSize();
            if (!inputStack.isEmpty() && (outputStack.isEmpty() || hasSpace) && (item = inputStack.getItem()) instanceof BucketItem) {
                BucketItem item2 = (BucketItem)item;
                Fluid fluid = FluidBucketHooks.getFluid((BucketItem)item2);
                if (!tank.isEmpty() && tank.getStack().getFluid() == fluid || tank.isEmpty() && !fluid.isSame(Fluids.EMPTY)) {
                    if (outputStack.isEmpty()) {
                        ((Container)blockEntity).setItem(outputSlot, new ItemStack((ItemLike)Items.BUCKET));
                    } else if (outputStack.is(Items.BUCKET) && hasSpace) {
                        outputStack.grow(1);
                    } else {
                        return false;
                    }
                    ((Container)blockEntity).setItem(inputSlot, ItemStack.EMPTY);
                    FluidTankHelper.addToTank(tank, FluidStack.create((Fluid)fluid, (long)BUCKET_AMOUNT));
                    blockEntity.setChanged();
                    return true;
                }
            }
        }
        return false;
    }

    public static void transferFluidNearby(BlockEntity entity, FluidTank fluidTank) {
        BlockPos[] pos1;
        BlockPos pos = entity.getBlockPos();
        List<BlockPos> adjacentBlocks = List.of(pos.above(), pos.below(), pos.relative(Direction.SOUTH), pos.relative(Direction.EAST), pos.relative(Direction.NORTH), pos.relative(Direction.WEST));
        for (BlockPos pos2 : pos1 = adjacentBlocks.toArray(new BlockPos[0])) {
            BlockEntity block = entity.getLevel().getBlockEntity(pos2);
            if (block == null) {
                return;
            }
            if (!(block instanceof WrappedFluidBlockEntity)) continue;
            WrappedFluidBlockEntity fluidBlock = (WrappedFluidBlockEntity)block;
            for (FluidTank tank : fluidBlock.getFluidTanks()) {
                if (tank.getStack().getFluid() == fluidTank.getStack().getFluid()) {
                    if (fluidTank.getAmount() - (long)FluidTankHelper.convertFromNeoMb(10) <= 0L || !tank.canGrow(FluidTankHelper.convertFromNeoMb(10))) continue;
                    tank.grow(FluidTankHelper.convertFromNeoMb(10));
                    fluidTank.shrink(FluidTankHelper.convertFromNeoMb(10));
                    entity.setChanged();
                    continue;
                }
                if (!tank.getStack().isEmpty()) continue;
                tank.setFluid(fluidTank.getStack().getFluid(), FluidTankHelper.convertFromNeoMb(10));
                fluidTank.shrink(FluidTankHelper.convertFromNeoMb(10));
                entity.setChanged();
            }
        }
    }

    public static long convertFromNeoMb(long amount) {
        return Platform.isFabric() ? amount * 81L : amount;
    }

    public static int convertFromNeoMb(int amount) {
        return Platform.isFabric() ? amount * 81 : amount;
    }

    public static int convertToNeoMb(int amount) {
        return Platform.isFabric() ? amount / 81 : amount;
    }
}

