/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;

public class FluidTank {
    private final String name;
    private final long maxCapacity;
    private FluidStack stack = FluidStack.empty();

    public FluidTank(String name, long maxCapacity) {
        this.name = name;
        this.maxCapacity = maxCapacity * FluidTankHelper.BUCKET_AMOUNT;
    }

    public FluidTank(String name, long maxCapacity, Fluid fluid) {
        this(name, maxCapacity);
        this.stack = FluidStack.create((Fluid)fluid, (long)0L);
    }

    public long getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setFluid(Fluid fluid, long amount) {
        this.stack = FluidStack.create((Fluid)fluid, (long)amount);
    }

    public long getAmount() {
        return this.stack.getAmount();
    }

    public void setAmount(long amount) {
        this.stack.setAmount(Mth.clamp((long)amount, (long)0L, (long)this.maxCapacity));
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public boolean canGrow(long amount) {
        return this.getAmount() + amount <= this.getMaxCapacity();
    }

    public void shrink(long amount) {
        this.grow(-amount);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public FluidStack getStack() {
        return this.stack;
    }

    public void load(HolderLookup.Provider provider, CompoundTag tag) {
        CompoundTag containerTag = tag.getCompound(this.name);
        this.stack = FluidStack.read((HolderLookup.Provider)provider, (Tag)containerTag).orElse(FluidStack.empty());
    }

    public void save(HolderLookup.Provider provider, CompoundTag tag) {
        if (!this.isEmpty()) {
            tag.put(this.name, this.stack.write(provider, (Tag)new CompoundTag()));
        }
    }
}

