/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.systems.energy.EnergyApi;
import com.st0x0ef.stellaris.common.systems.energy.impl.ExtractOnlyEnergyContainer;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGeneratorBlockEntity
extends BaseEnergyContainerBlockEntity {
    private WrappedBlockEnergyContainer energyContainer;
    protected int energyGeneratedPT;
    private final int maxCapacity;

    public BaseGeneratorBlockEntity(BlockEntityType<?> entityType, BlockPos blockPos, BlockState blockState, int energyGeneratedPT, int maxCapacity) {
        super(entityType, blockPos, blockState);
        this.energyGeneratedPT = energyGeneratedPT;
        this.maxCapacity = maxCapacity;
    }

    @Override
    public final WrappedBlockEnergyContainer getEnergyStorage(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer(entity, new ExtractOnlyEnergyContainer(this.maxCapacity, Integer.MAX_VALUE))) : this.energyContainer;
    }

    public int getEnergyGeneratedPT() {
        return this.energyGeneratedPT;
    }

    @Override
    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 1);
            super.setChanged();
        }
    }

    public abstract boolean canGenerate();

    @Override
    public void tick() {
        if (this.canGenerate()) {
            WrappedBlockEnergyContainer container = this.getWrappedEnergyContainer();
            if (container.getStoredEnergy() < container.getMaxCapacity()) {
                container.setEnergy(container.getStoredEnergy() + (long)this.energyGeneratedPT);
            } else if (container.getStoredEnergy() > container.getMaxCapacity()) {
                container.setEnergy(container.getMaxCapacity());
            }
        }
        EnergyApi.distributeEnergyNearby((BlockEntity)this, 100L);
    }
}

