/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities;

import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RadioactiveBlockEntity
extends BlockEntity {
    public int radioactivityLevel;
    int tickCount = 0;

    public RadioactiveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.RADIOACTIVE_BLOCK.get(), pos, state);
    }

    public RadioactiveBlockEntity(BlockPos pos, BlockState state, int level) {
        this(pos, state);
        this.radioactivityLevel = level;
    }

    public void tick() {
        AABB area = new AABB(this.getBlockPos()).inflate(5.0);
        if (this.tickCount >= 100) {
            List entities = this.level.getEntitiesOfClass(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                if (Utils.isLivingInJetSuit(entity) || entity.getType().is(TagRegistry.ENTITY_RADIATION_INVULNERABLE_TAG)) continue;
                entity.addEffect(new MobEffectInstance(EffectsRegistry.RADIOACTIVE, 100, this.radioactivityLevel - 1));
            }
            this.tickCount = 0;
        }
        ++this.tickCount;
    }
}

