/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@OnlyIn(value=Dist.CLIENT)
public class Gauge
extends AbstractWidget {
    protected ResourceLocation texture;
    protected int max_value;
    protected int value;
    public final ResourceLocation overlay_texture;
    private int yOffSet = 0;

    public Gauge(int x, int y, int width, int height, Component message, ResourceLocation texture, @Nullable ResourceLocation overlay_texture, int value, int max_value) {
        super(x, y, width, height, message);
        this.texture = texture;
        this.max_value = max_value;
        this.value = value;
        this.overlay_texture = overlay_texture;
    }

    public Gauge(int x, int y, int width, int height, Component message, ResourceLocation texture, @Nullable ResourceLocation overlay_texture, int value, int max_value, int yOffSet) {
        this(x, y, width, height, message, texture, overlay_texture, value, max_value);
        this.yOffSet = yOffSet;
    }

    public void update(int value) {
        this.value = value;
    }

    public void updateMaxValue(int value) {
        this.max_value = value;
    }

    public void updateFluidTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.value >= this.max_value) {
            this.value = this.max_value;
            graphics.blit(this.texture, this.getX(), this.getY(), (float)this.width, (float)(this.height - 1), this.width, this.height - 1, this.width, this.height - 1);
        } else if (this.value <= 0) {
            graphics.blit(this.texture, this.getX(), this.getY(), (float)this.width, (float)this.height, this.width, 0, this.width, 45);
        } else {
            int widgetY = this.getY() + 45 - 45 * this.value / this.max_value + this.yOffSet;
            graphics.blit(this.texture, this.getX(), widgetY, (float)this.width, (float)this.height, this.width, (int)(45.0f / ((float)this.max_value / (float)this.value)), this.width, 45);
        }
        if (this.overlay_texture != null) {
            ScreenHelper.drawTexture(this.getX(), this.getY(), this.width, this.height, this.overlay_texture, false);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, Font font) {
        this.renderTooltips(graphics, mouseX, mouseY, font, new ArrayList<Component>());
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, Font font, List<Component> components) {
        String GaugeComponent = this.getMessage().getString() + " : " + this.value + " / " + this.max_value;
        Component capacity = this.value >= this.max_value ? Utils.getMessageComponent(GaugeComponent, "Lime") : (this.value <= 0 ? Utils.getMessageComponent(GaugeComponent, "Red") : Utils.getMessageComponent(GaugeComponent, "Orange"));
        components.addFirst(capacity);
        if (mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= this.getY() && mouseY <= this.getY() + this.height) {
            graphics.renderComponentTooltip(font, components, mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Deprecated(forRemoval=true)
    public static class SidewayGauge
    extends Gauge {
        public SidewayGauge(int x, int y, int width, int height, @Nullable Component message, ResourceLocation texture, @Nullable ResourceLocation overlay_texture, int value, int max_value) {
            super(x, y, width, height, message, texture, overlay_texture, value, max_value);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int pourcent = this.width * this.value / this.max_value;
            graphics.blit(this.texture, this.getX(), this.getY(), (float)this.width, (float)this.height, pourcent, this.height, this.width, this.height);
            if (this.overlay_texture != null) {
                ScreenHelper.drawTexture(this.getX(), this.getY(), this.width, this.height, this.overlay_texture, false);
            }
        }
    }
}

