/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.PumpjackBlockEntity;
import com.st0x0ef.stellaris.common.menus.PumpjackMenu;
import com.st0x0ef.stellaris.common.utils.Utils;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PumpjackScreen
extends AbstractContainerScreen<PumpjackMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/pumpjack.png");
    private final PumpjackBlockEntity blockEntity = ((PumpjackMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget resultTankGauge;
    private GaugeWidget energyGauge;

    public PumpjackScreen(PumpjackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 177;
        this.imageHeight = 192;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        FluidTank resultTank = this.blockEntity.getResultTank();
        this.resultTankGauge = new GaugeWidget(this.leftPos + 79, this.topPos + 32, 12, 46, (Component)Component.translatable((String)"stellaris.screen.oil"), GUISprites.OIL_OVERLAY, GUISprites.LIQUID_TANK_OVERLAY, resultTank.getMaxCapacity() - 1L, GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.resultTankGauge);
        EnergyContainer energyContainer = this.blockEntity.getWrappedEnergyContainer().container();
        this.energyGauge = new GaugeWidget(this.leftPos + 147, this.topPos + 31, 13, 46, (Component)Component.translatable((String)"stellaris.screen.energy"), GUISprites.ENERGY_FULL, GUISprites.BATTERY_OVERLAY, energyContainer.getMaxCapacity(), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        guiGraphics.drawString(this.font, "Oil Level", this.leftPos + 20, this.topPos + 33, Utils.getColorHexCode("gray"));
        if (this.blockEntity.chunkOilLevel() > 5000) {
            guiGraphics.drawCenteredString(this.font, "" + this.blockEntity.chunkOilLevel(), this.leftPos + 40, this.topPos + 44, Utils.getColorHexCode("green"));
        } else if (this.blockEntity.chunkOilLevel <= 5000 && this.blockEntity.chunkOilLevel() > 2500) {
            guiGraphics.drawCenteredString(this.font, "" + this.blockEntity.chunkOilLevel(), this.leftPos + 40, this.topPos + 44, Utils.getColorHexCode("orange"));
        } else {
            guiGraphics.drawCenteredString(this.font, "" + this.blockEntity.chunkOilLevel(), this.leftPos + 40, this.topPos + 44, Utils.getColorHexCode("red"));
        }
        this.resultTankGauge.updateAmount(this.blockEntity.getResultTank().getAmount());
        this.energyGauge.updateAmount(this.blockEntity.getWrappedEnergyContainer().getStoredEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.resultTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }
}

