/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.globe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.common.blocks.entities.GlobeBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlobeModel<T extends GlobeBlockEntity>
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"globe"), "main");
    public final ModelPart globe;

    public GlobeModel(ModelPart root) {
        super(RenderType::entityCutout);
        this.globe = root.getChild("globe");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition globe = partdefinition.addOrReplaceChild("globe", CubeListBuilder.create().texOffs(0, 16).addBox(-7.0f, -16.0f, 1.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-4.0f, -1.0f, -2.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(-3.0f, -5.0f, -1.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -4.0f, 0.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)24.0f, (float)-1.0f));
        PartDefinition planet = globe.addOrReplaceChild("planet", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-10.0f, (float)1.0f));
        PartDefinition cube_r1 = planet.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.globe.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(GlobeBlockEntity entity, float partialTicks) {
        this.globe.getChild((String)"planet").yRot = Mth.lerp((float)partialTicks, (float)entity.getYaw0(), (float)entity.getYaw());
    }
}

