/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.globe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.client.renderers.globe.GlobeModel;
import com.st0x0ef.stellaris.common.items.GlobeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlobeItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private ResourceLocation texture;
    private GlobeModel<?> model;

    public GlobeItemRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public GlobeItemRenderer setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (item instanceof GlobeItem) {
            GlobeItem globeItem = (GlobeItem)item;
            this.texture = globeItem.getTexture();
        } else {
            this.texture = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/block/globes/earth_globe.png");
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 1.5, 0.5);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (this.model == null) {
            this.model = new GlobeModel(mc.getEntityModels().bakeLayer(GlobeModel.LAYER_LOCATION));
        }
        VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)this.texture));
        if (level != null && !mc.isPaused() && mc.getFps() > 0) {
            this.model.globe.getChild((String)"planet").yRot = (float)(level.getGameTime() + (long)(1 / mc.getFps())) / -20.0f;
        }
        this.model.renderToBuffer(matrixStackIn, vertexBuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStackIn.popPose();
    }
}

