/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.pygro;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PygroModel<T extends Mob>
extends PlayerModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"pygro"), "main");
    public final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public PygroModel(ModelPart p_170810_) {
        super(p_170810_, false);
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.bodyDefault = this.body.storePose();
        this.headDefault = this.head.storePose();
        this.leftArmDefault = this.leftArm.storePose();
        this.rightArmDefault = this.rightArm.storePose();
    }

    public static MeshDefinition createMesh(CubeDeformation p_170812_) {
        MeshDefinition meshdefinition = PlayerModel.createMesh((CubeDeformation)p_170812_, (boolean)false);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170812_), PartPose.ZERO);
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, p_170812_).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, p_170812_).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_170812_).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_170812_), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(39, 6).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_170812_), PartPose.offsetAndRotation((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        partdefinition1.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(39, 6).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_170812_), PartPose.offsetAndRotation((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition eyes = partdefinition1.addOrReplaceChild("eyesg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        eyes.addOrReplaceChild("eyes", CubeListBuilder.create().texOffs(46, 0).addBox(-4.5f, -4.5f, -0.75f, 9.0f, 7.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)-4.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition fang = partdefinition1.addOrReplaceChild("noseg1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        fang.addOrReplaceChild("nose1", CubeListBuilder.create().texOffs(33, 2).addBox(-1.25f, -1.35f, -0.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-25.0f, (float)-4.5f, (float)0.0631f, (float)0.3435f, (float)0.1855f));
        PartDefinition fang2 = partdefinition1.addOrReplaceChild("noseg2", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)24.0f, (float)0.0f));
        fang2.addOrReplaceChild("nose2", CubeListBuilder.create().texOffs(33, 2).addBox(-2.15f, -1.45f, -0.35f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-25.0f, (float)-4.5f, (float)0.0631f, (float)-0.3435f, (float)-0.1855f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.create((MeshDefinition)PygroModel.createMesh(CubeDeformation.NONE), (int)64, (int)64);
    }

    public void setupAnim(T p_103366_, float p_103367_, float p_103368_, float p_103369_, float p_103370_, float p_103371_) {
        this.body.loadPose(this.bodyDefault);
        this.head.loadPose(this.headDefault);
        this.leftArm.loadPose(this.leftArmDefault);
        this.rightArm.loadPose(this.rightArmDefault);
        super.setupAnim(p_103366_, p_103367_, p_103368_, p_103369_, p_103370_, p_103371_);
        float f = 0.5235988f;
        float f1 = p_103369_ * 0.1f + p_103367_ * 0.5f;
        float f2 = 0.08f + p_103368_ * 0.4f;
        this.leftEar.zRot = -0.5235988f - Mth.cos((float)(f1 * 1.2f)) * f2;
        this.rightEar.zRot = 0.5235988f + Mth.cos((float)f1) * f2;
        if (p_103366_ instanceof AbstractPiglin) {
            AbstractPiglin abstractpiglin = (AbstractPiglin)p_103366_;
            PiglinArmPose piglinarmpose = abstractpiglin.getArmPose();
            if (piglinarmpose == PiglinArmPose.DANCING) {
                float f3 = p_103369_ / 60.0f;
                this.rightEar.zRot = 0.5235988f + (float)Math.PI / 180 * Mth.sin((float)(f3 * 30.0f)) * 10.0f;
                this.leftEar.zRot = -0.5235988f - (float)Math.PI / 180 * Mth.cos((float)(f3 * 30.0f)) * 10.0f;
                this.head.x = Mth.sin((float)(f3 * 10.0f));
                this.head.y = Mth.sin((float)(f3 * 40.0f)) + 0.4f;
                this.rightArm.zRot = (float)Math.PI / 180 * (70.0f + Mth.cos((float)(f3 * 40.0f)) * 10.0f);
                this.leftArm.zRot = this.rightArm.zRot * -1.0f;
                this.rightArm.y = Mth.sin((float)(f3 * 40.0f)) * 0.5f + 1.5f;
                this.leftArm.y = Mth.sin((float)(f3 * 40.0f)) * 0.5f + 1.5f;
                this.body.y = Mth.sin((float)(f3 * 40.0f)) * 0.35f;
            } else if (piglinarmpose == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON && this.attackTime == 0.0f) {
                this.holdWeaponHigh(p_103366_);
            } else if (piglinarmpose == PiglinArmPose.CROSSBOW_HOLD) {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (!p_103366_.isLeftHanded() ? 1 : 0) != 0);
            } else if (piglinarmpose == PiglinArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_103366_, (!p_103366_.isLeftHanded() ? 1 : 0) != 0);
            } else if (piglinarmpose == PiglinArmPose.ADMIRING_ITEM) {
                this.head.xRot = 0.5f;
                this.head.yRot = 0.0f;
                if (p_103366_.isLeftHanded()) {
                    this.rightArm.yRot = -0.5f;
                    this.rightArm.xRot = -0.9f;
                } else {
                    this.leftArm.yRot = 0.5f;
                    this.leftArm.xRot = -0.9f;
                }
            }
        } else if (p_103366_.getType() == EntityType.ZOMBIFIED_PIGLIN) {
            AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)p_103366_.isAggressive(), (float)this.attackTime, (float)p_103369_);
        }
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        this.hat.copyFrom(this.head);
    }

    protected void setupAttackAnimation(T p_103363_, float p_103364_) {
        if (this.attackTime > 0.0f && p_103363_ instanceof Piglin && ((Piglin)p_103363_).getArmPose() == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON) {
            AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_103363_, (float)this.attackTime, (float)p_103364_);
        } else {
            super.setupAttackAnimation(p_103363_, p_103364_);
        }
    }

    private void holdWeaponHigh(T p_103361_) {
        if (p_103361_.isLeftHanded()) {
            this.leftArm.xRot = -1.8f;
        } else {
            this.rightArm.xRot = -1.8f;
        }
    }
}

