/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.mogler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoglerModel<T extends Mob>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"mogler"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public MoglerModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -15.0f, -13.0f, 16.0f, 9.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(85, 30).addBox(-9.0f, -20.0f, 12.0f, 18.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 41).addBox(-10.0f, -18.0f, 5.0f, 20.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(58, 52).addBox(-11.0f, -18.0f, 2.0f, 22.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(64, 0).addBox(-12.0f, -22.0f, -4.0f, 24.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 66).addBox(-10.0f, -26.0f, -3.0f, 20.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 22).addBox(-7.5f, -8.5f, -1.75f, 15.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.5f, (float)-20.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(62, 75).addBox(-9.0f, -8.5f, -1.75f, 18.0f, 13.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition jaw2 = head.addOrReplaceChild("jaw2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = jaw2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(96, 99).addBox(5.25f, -1.5f, -0.75f, 5.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition jaw1 = head.addOrReplaceChild("jaw1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = jaw1.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 110).addBox(-10.25f, -1.5f, -0.75f, 5.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(64, 99).addBox(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.5f, (float)14.5f, (float)-6.5f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(32, 90).addBox(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.5f, (float)14.5f, (float)-6.5f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 88).addBox(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.5f, (float)14.5f, (float)12.5f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.5f, (float)14.5f, (float)12.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        int i = ((HoglinBase)entity).getAttackAnimationRemainingTicks();
        float f = 1.0f - (float)Mth.abs((int)(10 - 2 * i)) / 10.0f;
        this.head.xRot = Mth.lerp((float)f, (float)0.0f, (float)-1.1490659f);
        this.leg1.xRot = Mth.cos((float)limbSwing) * 1.2f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.leg3.xRot = this.leg1.xRot;
        this.leg4.xRot = this.leg2.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0f, 1.5f, 0.0f);
        }
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg1.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg3.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg4.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.leg4);
    }
}

