/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.armors;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JetSuitModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"jetsuit"), "main");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/models/armor/jetsuit_layer_1.png");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart left_boot;
    private final ModelPart right_boot;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final HumanoidModel<LivingEntity> parentModel;
    private final EquipmentSlot slot;

    public JetSuitModel(ModelPart root, EquipmentSlot slot, ItemStack stack, @Nullable HumanoidModel<LivingEntity> parentModel) {
        super(root, RenderType::entityTranslucent);
        this.parentModel = parentModel;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
        this.left_boot = this.left_leg.getChild("left_boot");
        this.right_boot = this.right_leg.getChild("right_boot");
        this.slot = slot;
        this.setVisible();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0), PartPose.ZERO);
        PartDefinition visor = partdefinition.addOrReplaceChild("visor", CubeListBuilder.create().texOffs(0, 0), PartPose.ZERO);
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.75f)).texOffs(14, 59).addBox(3.0f, -13.0f, 1.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0175f, (float)0.0873f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(28, 28).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(50, 29).addBox(-3.0f, 5.0f, -2.5f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(0, 55).addBox(-2.5f, 1.0f, 2.75f, 5.0f, 8.0f, 1.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("Body_r1", CubeListBuilder.create().texOffs(32, 31).addBox(-2.0f, -5.0f, 0.75f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition body_r2 = body.addOrReplaceChild("Body_r2", CubeListBuilder.create().texOffs(32, 31).addBox(2.0f, -5.0f, 0.75f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)2.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition armr = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(20, 44).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.26f)).texOffs(48, 8).addBox(-3.0f, 6.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition arml = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.26f)).texOffs(48, 0).addBox(-1.0f, 6.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(33, 19).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(33, 19).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.offset((float)2.1f, (float)12.0f, (float)0.0f));
        PartDefinition Right_boot = RightLeg.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(48, 44).addBox(-2.0f, 5.7f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(48, 54).addBox(-2.0f, 5.7f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.27f)), PartPose.offset((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Left_boot = LeftLeg.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(48, 44).addBox(-2.0f, 5.7f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(48, 54).addBox(-2.0f, 5.7f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.27f)), PartPose.offset((float)-0.1f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (Platform.isNeoForge()) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        }
        this.parentModel.copyPropertiesTo((HumanoidModel)this);
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat, (Object)this.left_boot, (Object)this.right_boot);
    }

    private void setVisible() {
        this.setAllVisible(false);
        switch (this.slot) {
            case HEAD: {
                this.head.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
            }
        }
    }
}

