/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VenusRainParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final float angularVelocity;
    private final float angularAcceleration;

    public VenusRainParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.quadSize *= 1.0f;
        this.hasPhysics = true;
        this.angularVelocity = 0.1f;
        this.angularAcceleration = 0.01f;
        this.xd *= 0.3;
        this.yd = Math.random() * 0.2 + 0.1;
        this.zd *= 0.3;
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.age = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age-- <= 0) {
            this.remove();
        } else {
            BlockPos blockpos;
            double d0;
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.98;
            this.yd *= 0.98;
            this.zd *= 0.98;
            if (this.onGround) {
                if (Math.random() < 0.5) {
                    this.remove();
                }
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
            if ((d0 = Math.max(this.level.getBlockState(blockpos = new BlockPos((int)this.x, (int)this.y, (int)this.z)).getCollisionShape((BlockGetter)this.level, blockpos).max(Direction.Axis.Y, this.x - (double)blockpos.getX(), this.z - (double)blockpos.getZ()), (double)this.level.getFluidState(blockpos).getHeight((BlockGetter)this.level, blockpos))) > 0.0 && this.y < (double)blockpos.getY() + d0) {
                this.remove();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public ParticleFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VenusRainParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

