/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.st0x0ef.stellaris.common.items.armors.JetSuit;
import com.st0x0ef.stellaris.common.utils.FuelUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class JetSuitOverlay {
    public static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (Utils.isLivingInJetSuit((LivingEntity)player)) {
            ItemStack itemStack = player.getItemBySlot(EquipmentSlot.CHEST);
            int x = 5;
            int y = 5;
            Item item = itemStack.getItem();
            if (item instanceof JetSuit.Suit) {
                JetSuit.Suit jetSuitItem = (JetSuit.Suit)item;
                Component modeText = jetSuitItem.getModeType(itemStack).getComponent();
                ChatFormatting chatFormatting = jetSuitItem.getModeType(itemStack).getChatFormatting();
                String fuel = String.valueOf(FuelUtils.getFuel(itemStack));
                Font font = Minecraft.getInstance().font;
                MutableComponent text = Component.translatable((String)"general.stellaris.jet_suit_mode").append(": ").withStyle(chatFormatting).append((Component)modeText.copy().withStyle(ChatFormatting.GRAY));
                graphics.drawString(font, (Component)text, x + (80 - font.width((FormattedText)text)) / 2, y + 83, 0xFFFFFF);
                MutableComponent fuelText = Component.translatable((String)"general.stellaris.jet_suit_fuel").append(": ").withStyle(chatFormatting).append(fuel).withStyle(ChatFormatting.GRAY);
                graphics.drawString(font, (Component)fuelText, x + (80 - font.width((FormattedText)fuelText)) / 2, y + 92, 0xFFFFFF);
            }
        }
    }
}

