/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.st0x0ef.stellaris.common.config.CustomConfig;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.data.screen.MoonPack;
import com.st0x0ef.stellaris.common.data.screen.PlanetPack;
import com.st0x0ef.stellaris.common.data.screen.StarPack;
import com.st0x0ef.stellaris.common.events.Events;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import com.st0x0ef.stellaris.common.network.packets.SyncPlanetsDatapackPacket;
import com.st0x0ef.stellaris.common.registry.ArmorMaterialsRegistry;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.CommandsRegistry;
import com.st0x0ef.stellaris.common.registry.CreativeTabsRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityData;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.FeaturesRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.LookupApiRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import com.st0x0ef.stellaris.common.registry.ParticleRegistry;
import com.st0x0ef.stellaris.common.registry.ProcessorsRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.function.BiConsumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stellaris {
    public static final String MODID = "stellaris";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Stellaris");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();

    public static void init() {
        CustomConfig.init();
        EntityData.register();
        NetworkRegistry.init();
        ProcessorsRegistry.STRUCTURE_PROCESSORS.register();
        SoundRegistry.SOUNDS.register();
        DataComponentsRegistry.DATA_COMPONENT_TYPE.register();
        FluidRegistry.init();
        ParticleRegistry.PARTICLES.register();
        BlocksRegistry.BLOCKS.register();
        EntityRegistry.ENTITY_TYPE.register();
        EntityRegistry.SENSOR.register();
        BlockEntityRegistry.BLOCK_ENTITY_TYPE.register();
        ItemsRegistry.ITEMS.register();
        ArmorMaterialsRegistry.ARMOR_MATERIAL.register();
        CreativeTabsRegistry.TABS.register();
        MenuTypesRegistry.MENU_TYPE.register();
        FeaturesRegistry.FEATURES.register();
        CommandsRegistry.register();
        Events.registerEvents();
        LookupApiRegistry.registerEnergy();
        RecipesRegistry.register();
        EntityRegistry.registerSpawnPlacements();
        EffectsRegistry.register();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new StellarisData());
    }

    public static void onDatapackSyncEvent(ServerPlayer player, boolean joined) {
        if (joined) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPlanetsDatapackPacket(StellarisData.getPlanets()));
        }
    }

    public static void onAddReloadListenerEvent(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"planets"), (PreparableReloadListener)new StellarisData());
    }

    public static void onAddReloadClientListenerEvent(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"stars_pack"), (PreparableReloadListener)new StarPack());
        registry.accept(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"planets_pack"), (PreparableReloadListener)new PlanetPack());
        registry.accept(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"moon_packs"), (PreparableReloadListener)new MoonPack());
    }
}

